/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.rhq.plugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.modeshape.rhq.plugin.objects.ExecutedResult;
import org.modeshape.rhq.plugin.util.PluginConstants;
import org.modeshape.rhq.plugin.util.ProfileServiceUtil;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;

public class ModeShapeManagementView
implements PluginConstants {
    private static final Log LOG = LogFactory.getLog((String)"org.modeshape");

    public Object getMetric(ProfileServiceConnection connection, String componentType, String identifier, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        if (componentType.equals("ModeShapeSequencingService")) {
            resultObject = this.getSequencerServiceMetric(connection, componentType, metric, valueMap);
        } else if (componentType.equals("Connector")) {
            resultObject = this.getConnectorMetric(connection, componentType, metric, valueMap);
        } else if (componentType.equals("Repository")) {
            resultObject = this.getRepositoryMetric(connection, componentType, metric, valueMap);
        }
        return resultObject;
    }

    private Object getSequencerServiceMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getNodesSequencedCount") || metric.equals("getNodesSkippedCount")) {
            value = this.executeSequencingServiceOperation(connection, metric, valueMap);
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    private Object getRepositoryMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getActiveSessions")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)((String)valueMap.get("repositoryName"))))});
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    private Object getConnectorMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getInUseConnections")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)((String)valueMap.get("connectorName"))))});
            resultObject = ProfileServiceUtil.stringValue(value);
        } else if (metric.equals("getActiveSessions")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)((String)valueMap.get("connectorName"))))});
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    public void executeOperation(ProfileServiceConnection connection, ExecutedResult operationResult, Map<String, Object> valueMap) {
        if (operationResult.getComponentType().equals("ModeShapeEngine")) {
            this.executeEngineOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        } else if (!operationResult.getComponentType().equals("Repository") && operationResult.getComponentType().equals("Connector")) {
            this.executeConnectorOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        }
    }

    private void executeEngineOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        try {
            ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), operationName, new MetaValue[]{null});
        }
        catch (Exception e) {
            String msg = "Exception executing operation: " + operationName;
            LOG.error((Object)msg, (Throwable)e);
        }
    }

    private void executeConnectorOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        if (operationName.equals("pingConnector")) {
            try {
                String connectorName = (String)valueMap.get("connectorName");
                MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)connectorName))};
                MetaValue value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), operationName, operationResult, args);
                operationResult.setContent(value);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: pingConnector";
                LOG.error((Object)"Exception executing operation: pingConnector", (Throwable)e);
            }
        }
    }

    private MetaValue executeSequencingServiceOperation(ProfileServiceConnection connection, String operationName, Map<String, Object> valueMap) {
        MetaValue value = null;
        try {
            MetaValue[] args = new MetaValue[]{};
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedSequencingService(connection), operationName, args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: " + operationName;
            LOG.error((Object)msg, (Throwable)e);
        }
        return value;
    }

    public static MetaValue executeManagedOperation(ManagedComponent mc, String operation, MetaValue ... args) throws Exception {
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            try {
                if (args == null || args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception invoking " + operation;
                LOG.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        throw new Exception("No operation found with given name =" + operation);
    }

    public static MetaValue executeManagedOperation(ManagedComponent mc, String operation, ExecutedResult operationResult, MetaValue ... args) throws Exception {
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            operationResult.setManagedOperation(mo);
            try {
                if (args == null || args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception invoking " + operation;
                LOG.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        throw new Exception("No operation found with given name =" + operation);
    }

    public static Collection<MetaValue> getRepositoryCollectionValue(MetaValue pValue) {
        ArrayList<MetaValue> list = new ArrayList<MetaValue>();
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                MetaValue repository = value;
                list.add(repository);
            }
        }
        return list;
    }

    public static String getConnectorPingString(MetaValue pValue) throws Exception {
        MetaType metaType = pValue.getMetaType();
        StringBuffer sb = new StringBuffer();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                String resultValue = ProfileServiceUtil.stringValue(value);
                sb.append(resultValue + " ");
            }
        }
        return sb.toString();
    }

    public static Collection<MetaValue> getSequencerCollectionValue(MetaValue pValue) {
        ArrayList<MetaValue> list = new ArrayList<MetaValue>();
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                MetaValue sequencer = value;
                list.add(sequencer);
            }
        }
        return list;
    }
}

