/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.rhq.plugin.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;

public class ProfileServiceUtil {
    protected static final Log LOG = LogFactory.getLog((String)"org.modeshape");

    public static ManagedComponent getManagedComponent(ProfileServiceConnection connection, ComponentType componentType, String componentName) throws NamingException, Exception {
        ManagedComponent mc = connection.getManagementView().getComponent(componentName, componentType);
        return mc;
    }

    public static ManagedComponent getManagedEngine(ProfileServiceConnection connection) throws NamingException, Exception {
        ManagedComponent mc = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("ModeShape", "Engine"), "ModeShapeEngine");
        return mc;
    }

    public static ManagedComponent getManagedSequencingService(ProfileServiceConnection connection) throws NamingException, Exception {
        ManagedComponent mc = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("ModeShape", "SequencingService"), "ModeShapeSequencingService");
        return mc;
    }

    public static Set<ManagedComponent> getManagedComponents(ProfileServiceConnection connection, ComponentType componentType) throws NamingException, Exception {
        ManagementView mv = connection.getManagementView();
        Set mcSet = mv.getComponentsForType(componentType);
        return mcSet;
    }

    public static ManagementView getManagementView(ProfileServiceConnection connection) {
        ManagementView mv = connection.getManagementView();
        return mv;
    }

    public static DeploymentManager getDeploymentManager(ProfileServiceConnection connection) throws NamingException, Exception {
        DeploymentManager deploymentManager = connection.getDeploymentManager();
        return deploymentManager;
    }

    public static File getDeployDirectory(ProfileServiceConnection connection) throws NamingException, Exception {
        URL warUrl;
        Set warDeployments;
        ManagementView mv = connection.getManagementView();
        try {
            warDeployments = mv.getDeploymentsForType(KnownDeploymentTypes.JavaEEWebApplication.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ManagedDeployment standaloneWarDeployment = null;
        for (ManagedDeployment warDeployment : warDeployments) {
            if (warDeployment.getParent() != null) continue;
            standaloneWarDeployment = warDeployment;
            break;
        }
        if (standaloneWarDeployment == null) {
            return null;
        }
        try {
            warUrl = new URL(standaloneWarDeployment.getName());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        File warFile = new File(warUrl.getPath());
        File deployDir = warFile.getParentFile();
        return deployDir;
    }

    public static String stringValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return simple.getValue().toString();
            }
            throw new Exception("Failed to convert value to string value");
        }
        return null;
    }

    public static Boolean booleanValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return Boolean.valueOf(simple.getValue().toString());
            }
            throw new Exception("Failed to convert value to boolean value");
        }
        return null;
    }

    public static <T> T getSimpleValue(ManagedComponent mc, String prop, Class<T> expectedType) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)mp.getValue();
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)mp.getValue();
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalStateException(prop + " is not a simple type");
        }
        return null;
    }

    public static <T> T getSimpleValue(ManagedCommon mc, String prop, Class<T> expectedType) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)mp.getValue();
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)mp.getValue();
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalArgumentException(prop + " is not a simple type");
        }
        return null;
    }

    public static Map<String, PropertySimple> getCustomProperties(Configuration pluginConfig) {
        LinkedHashMap<String, PropertySimple> customProperties = new LinkedHashMap<String, PropertySimple>();
        if (pluginConfig == null) {
            return customProperties;
        }
        PropertyMap customPropsMap = pluginConfig.getMap("custom-properties");
        if (customPropsMap != null) {
            Collection customProps = customPropsMap.getMap().values();
            for (Property customProp : customProps) {
                if (!(customProp instanceof PropertySimple)) {
                    LOG.error((Object)("Custom property definitions in plugin configuration must be simple properties - property " + customProp + " is not - ignoring..."));
                    continue;
                }
                customProperties.put(customProp.getName(), (PropertySimple)customProp);
            }
        }
        return customProperties;
    }

    public static Configuration convertManagedObjectToConfiguration(Map<String, ManagedProperty> managedProperties, Map<String, PropertySimple> customProps, ResourceType resourceType) {
        return null;
    }

    public static void convertConfigurationToManagedProperties(Map<String, ManagedProperty> managedProperties, Configuration configuration, ResourceType resourceType) {
        ConfigurationDefinition configDefinition = resourceType.getResourceConfigurationDefinition();
        for (ManagedProperty managedProperty : managedProperties.values()) {
            String propertyName = managedProperty.getName();
            PropertyDefinition propertyDefinition = configDefinition.get(propertyName);
            if (propertyDefinition == null) continue;
            ProfileServiceUtil.populateManagedPropertyFromProperty(managedProperty, propertyDefinition, configuration);
        }
    }

    public static void populateManagedPropertyFromProperty(ManagedProperty managedProperty, PropertyDefinition propertyDefinition, Configuration configuration) {
    }

    public static MetaType convertPropertyDefinitionToMetaType(PropertyDefinition propDef) {
        MetaType memberMetaType;
        if (propDef instanceof PropertyDefinitionSimple) {
            PropertySimpleType propSimpleType = ((PropertyDefinitionSimple)propDef).getType();
            memberMetaType = ProfileServiceUtil.convertPropertySimpleTypeToSimpleMetaType(propSimpleType);
        } else if (propDef instanceof PropertyDefinitionList) {
            memberMetaType = null;
        } else if (propDef instanceof PropertyDefinitionMap) {
            Map memberPropDefs = ((PropertyDefinitionMap)propDef).getPropertyDefinitions();
            if (memberPropDefs.isEmpty()) {
                throw new IllegalStateException("PropertyDefinitionMap doesn't contain any member PropertyDefinitions.");
            }
            PropertyDefinition mapMemberPropDef = (PropertyDefinition)memberPropDefs.values().iterator().next();
            MetaType mapMemberMetaType = ProfileServiceUtil.convertPropertyDefinitionToMetaType(mapMemberPropDef);
            memberMetaType = new MapCompositeMetaType(mapMemberMetaType);
        } else {
            throw new IllegalStateException("List member PropertyDefinition has unknown type: " + propDef.getClass().getName());
        }
        return memberMetaType;
    }

    private static MetaType convertPropertySimpleTypeToSimpleMetaType(PropertySimpleType memberSimpleType) {
        Class memberClass;
        switch (memberSimpleType) {
            case BOOLEAN: {
                memberClass = Boolean.class;
                break;
            }
            case INTEGER: {
                memberClass = Integer.class;
                break;
            }
            case LONG: {
                memberClass = Long.class;
                break;
            }
            case FLOAT: {
                memberClass = Float.class;
                break;
            }
            case DOUBLE: {
                memberClass = Double.class;
                break;
            }
            default: {
                memberClass = String.class;
            }
        }
        SimpleMetaType memberMetaType = SimpleMetaType.resolve((String)memberClass.getName());
        return memberMetaType;
    }
}

