/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.Session;
import org.modeshape.test.integration.RepositoryProvider;

@Singleton
@Startup
public class BackupRestoreBean
extends RepositoryProvider {
    private boolean backupRestoreSuccessful = false;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void run() throws Exception {
        String path = System.getProperty("jboss.server.base.dir");
        if (StringUtil.isBlank((String)path)) {
            throw new IllegalStateException("Cannot locate the jboss server dir");
        }
        File backupDirectory = new File(path);
        Repository repository = (Repository)this.getRepositoryFromJndi("java:/jcr/sample");
        Session session = (Session)repository.login();
        RepositoryManager repoMgr = session.getWorkspace().getRepositoryManager();
        Problems problems = repoMgr.backupRepository(backupDirectory);
        if (problems.hasProblems()) {
            throw new IllegalStateException("Errors while backing up repository:" + problems.toString());
        }
        problems = session.getWorkspace().getRepositoryManager().restoreRepository(backupDirectory);
        if (problems.hasProblems()) {
            throw new IllegalStateException("Errors while backing up repository:" + problems.toString());
        }
        this.backupRestoreSuccessful = true;
    }

    public boolean isBackupRestoreSuccessful() {
        return this.backupRestoreSuccessful;
    }
}

