/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.RepositoryException;
import net.jcip.annotations.Immutable;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.jboss.managed.JBossManagedI18n;
import org.modeshape.jboss.managed.ManagedConnector;
import org.modeshape.jboss.managed.ManagedRepository;
import org.modeshape.jboss.managed.ManagedSequencingService;
import org.modeshape.jboss.managed.ModeShapeManagedObject;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

@Immutable
@ManagementObject(isRuntime=true, name="ModeShapeEngine", description="A ModeShape engine", componentType=@ManagementComponent(type="ModeShape", subtype="Engine"), properties=ManagementProperties.EXPLICIT)
public final class ManagedEngine
implements ModeShapeManagedObject {
    private JcrEngine engine;
    private ManagedSequencingService sequencingService;

    public ManagedEngine() {
        this.engine = null;
    }

    public ManagedEngine(JcrEngine engine) {
        CheckArg.isNotNull((Object)engine, (String)"engine");
        this.engine = engine;
    }

    @ManagementOperation(description="Obtains the managed connectors of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<ManagedConnector> getConnectors() {
        ArrayList<ManagedConnector> connectors = new ArrayList<ManagedConnector>();
        if (this.isRunning()) {
            for (String repositoryName : this.engine.getRepositoryNames()) {
                RepositorySource repositorySource = this.engine.getRepositorySource(repositoryName);
                assert (repositorySource != null) : "Repository '" + repositoryName + "' does not exist";
                connectors.add(new ManagedConnector(repositorySource));
            }
        }
        return Collections.unmodifiableCollection(connectors);
    }

    @ManagementOperation(description="Obtains the managed repositories of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<ManagedRepository> getRepositories() {
        ArrayList<ManagedRepository> repositories = new ArrayList<ManagedRepository>();
        if (this.isRunning()) {
            for (String repositoryName : this.engine.getRepositoryNames()) {
                try {
                    JcrRepository repository = this.engine.getRepository(repositoryName);
                    repositories.add(new ManagedRepository(repository));
                }
                catch (RepositoryException e) {
                    Logger.getLogger(this.getClass()).log(Logger.Level.ERROR, (Throwable)e, JBossManagedI18n.errorGettingRepositoryFromEngine, new Object[]{repositoryName});
                }
            }
        }
        return repositories;
    }

    public ManagedRepository getRepository(String repositoryName) {
        if (this.isRunning()) {
            try {
                JcrRepository repository = this.engine.getRepository(repositoryName);
                if (repository != null) {
                    return new ManagedRepository(repository);
                }
            }
            catch (RepositoryException e) {
                Logger.getLogger(this.getClass()).log(Logger.Level.ERROR, (Throwable)e, JBossManagedI18n.errorGettingRepositoryFromEngine, new Object[]{repositoryName});
            }
        }
        return null;
    }

    @ManagementOperation(description="Obtains the managed sequencing service of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public ManagedSequencingService getSequencingService() {
        if (this.isRunning()) {
            if (this.sequencingService == null) {
                this.sequencingService = new ManagedSequencingService(this.engine.getSequencingService());
            }
        } else {
            this.sequencingService = null;
        }
        return this.sequencingService;
    }

    @ManagementOperation(description="Obtains the version of this ModeShape instance", impact=ManagedOperation.Impact.ReadOnly)
    public String getVersion() {
        return this.engine.getEngineVersion();
    }

    @ManagementOperation(description="Indicates if this engine is running", impact=ManagedOperation.Impact.ReadOnly)
    public boolean isRunning() {
        try {
            this.engine.getRepositoryService();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @ManagementOperation(description="Restarts this engine", impact=ManagedOperation.Impact.Lifecycle)
    public void restart() {
        this.shutdown();
        this.start();
    }

    @ManagementOperation(description="Shutdowns this engine", impact=ManagedOperation.Impact.Lifecycle)
    public void shutdown() {
        this.engine.shutdown();
    }

    @ManagementOperation(description="Starts this engine", impact=ManagedOperation.Impact.Lifecycle)
    public void start() {
        this.engine.start();
        this.getRepositories();
    }

    protected JcrEngine getEngine() {
        return this.engine;
    }

    public void setEngine(JcrEngine jcrEngine) {
        this.engine = jcrEngine;
    }

    public void setConfigURL(URL configurationUrl) throws Exception {
        JcrConfiguration jcrConfig = new JcrConfiguration().loadFrom(configurationUrl);
        this.engine = jcrConfig.build();
    }
}

