/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jboss.managed.ManagedEngine;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class ManagedEngineTest {
    private static Set<String> REPO_NAMES = null;
    private ManagedEngine me;
    private JcrConfiguration configuration;
    private JcrEngine engine;

    @BeforeClass
    public static void beforeAll() throws Exception {
        REPO_NAMES = new HashSet<String>();
        REPO_NAMES.add("JCR Repository");
    }

    @Before
    public void beforeEach() throws Exception {
        this.configuration = new JcrConfiguration();
        ((JcrConfiguration)((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source2").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setDescription("description")).and()).repository("JCR Repository").setSource("Source2").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "test").and()).save();
        this.engine = this.configuration.build();
        this.me = new ManagedEngine(this.engine);
        this.me.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Test
    public void shouldBeRunning() throws Exception {
        Assert.assertThat((Object)this.me.isRunning(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetRepository() throws Exception {
        Assert.assertThat((Object)this.me.getRepository(REPO_NAMES.iterator().next()), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldGetSequencingService() throws Exception {
        Assert.assertThat((Object)this.me.getSequencingService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldGetRepositories() throws Exception {
        Assert.assertThat((Object)this.me.getRepositories().size(), (Matcher)Is.is((Object)REPO_NAMES.size()));
    }
}

