/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.managed.ManagedEngine;
import org.modeshape.jboss.managed.ManagedSequencerConfig;
import org.modeshape.jboss.managed.ModeShapeManagedObject;
import org.modeshape.jboss.managed.util.ManagedUtils;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencingService;

@Immutable
@ManagementObject(isRuntime=true, name="ModeShapeSequencingService", description="A ModeShape sequencing service", componentType=@ManagementComponent(type="ModeShape", subtype="SequencingService"), properties=ManagementProperties.EXPLICIT)
public class ManagedSequencingService
implements ModeShapeManagedObject {
    private ManagedEngine engine;

    public ManagedSequencingService() {
    }

    public ManagedSequencingService(ManagedEngine managedEngine) {
        CheckArg.isNotNull((Object)managedEngine, (String)"managedEngine");
    }

    public void setManagedEngine(ManagedEngine managedEngine) throws Exception {
        this.engine = managedEngine;
    }

    public ManagedEngine getEngine() {
        return this.engine;
    }

    @ManagementProperty(name="Job Activity", description="The number of sequencing jobs executed", readOnly=true, use={ViewUse.STATISTIC})
    public int getJobActivity() {
        return 0;
    }

    @ManagementOperation(name="Nodes Sequenced", description="The number of nodes that have been sequenced")
    public long getNodesSequencedCount() {
        SequencingService sequencingService = this.engine.getSequencingService();
        return sequencingService == null ? 0L : sequencingService.getStatistics().getNumberOfNodesSequenced();
    }

    @ManagementOperation(name="Nodes Skipped", description="The number of nodes skipped (not sequenced)")
    public long getNodesSkippedCount() {
        SequencingService sequencingService = this.engine.getSequencingService();
        return sequencingService == null ? 0L : sequencingService.getStatistics().getNumberOfNodesSkipped();
    }

    @ManagementProperty(name="Queued Jobs", description="The number of queued jobs", readOnly=true, use={ViewUse.STATISTIC})
    public int getQueuedJobCount() {
        return 0;
    }

    @ManagementProperty(name="Start Time", description="The time the sequencing statistics (sequenced, skipped) began", readOnly=true, use={ViewUse.RUNTIME})
    public long getStartTime() {
        SequencingService sequencingService = this.engine.getSequencingService();
        return sequencingService == null ? 0L : sequencingService.getStatistics().getStartTime();
    }

    @ManagementOperation(description="Obtains the list of queued managed jobs", impact=ManagedOperation.Impact.ReadOnly)
    public Object listQueuedJobs() {
        return null;
    }

    @ManagementOperation(description="Obtains the properties for an object", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedEngine.ManagedProperty> getProperties(String objectName, ManagedEngine.Component objectType) {
        SequencingService sequencingService = this.engine.getSequencingService();
        if (sequencingService == null) {
            return Collections.emptyList();
        }
        List<ManagedEngine.ManagedProperty> managedProps = new ArrayList<ManagedEngine.ManagedProperty>();
        if (objectType.equals((Object)ManagedEngine.Component.SEQUENCER)) {
            SequencerConfig sequencerConfig = this.getSequencer(objectName);
            managedProps = ManagedUtils.getProperties(objectType, sequencerConfig);
        } else if (objectType.equals((Object)ManagedEngine.Component.SEQUENCINGSERVICE)) {
            managedProps = ManagedUtils.getProperties(objectType, sequencingService);
            managedProps.addAll(ManagedUtils.getProperties(objectType, sequencingService.getStatistics()));
        }
        return managedProps;
    }

    @ManagementOperation(name="Sequencers", description="The sequencers currently deployed", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<ManagedSequencerConfig> getSequencers() {
        SequencingService sequencingService = this.engine.getSequencingService();
        if (sequencingService == null) {
            return Collections.emptyList();
        }
        List sequencerConfigList = sequencingService.getSequencers();
        ArrayList<ManagedSequencerConfig> managedSequencerConfigList = new ArrayList<ManagedSequencerConfig>();
        for (SequencerConfig sequencerConfig : sequencerConfigList) {
            managedSequencerConfigList.add(new ManagedSequencerConfig(sequencerConfig.getName(), sequencerConfig.getDescription()));
        }
        return managedSequencerConfigList;
    }

    public SequencerConfig getSequencer(String sequencerName) {
        SequencingService sequencingService = this.engine.getSequencingService();
        if (sequencingService == null) {
            return null;
        }
        return this.getSequencerFrom(sequencingService, sequencerName);
    }

    protected SequencerConfig getSequencerFrom(SequencingService sequencingService, String sequencerName) {
        assert (sequencingService != null);
        for (SequencerConfig sequencerConfig : sequencingService.getSequencers()) {
            if (!sequencerName.equals(sequencerConfig.getName())) continue;
            return sequencerConfig;
        }
        return null;
    }
}

