/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jboss.subsystem.ModeShapeExtension;
import org.modeshape.jboss.subsystem.ObjectConverterUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestModeShapeConfiguration
extends AbstractSubsystemTest {
    public TestModeShapeConfiguration() {
        super("modeshape", (Extension)new ModeShapeExtension());
    }

    @Test
    public void testDescribeHandler() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        KernelServices servicesA = super.installInController(new AdditionalInitialization(){

            protected OperationContext.Type getType() {
                return OperationContext.Type.MANAGEMENT;
            }
        }, subsystemXml);
        ModelNode modelA = servicesA.readWholeModel();
        String marshalled = servicesA.getPersistedSubsystemXml();
        ModelNode describeOp = new ModelNode();
        describeOp.get("operation").set("describe");
        describeOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")}).toModelNode());
        List operations = AbstractSubsystemTest.checkResultAndGetContents((ModelNode)servicesA.executeOperation(describeOp)).asList();
        KernelServices servicesB = super.installInController(operations);
        ModelNode modelB = servicesB.readWholeModel();
    }

    @Test
    public void testOutputPersistance() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        KernelServices services = super.installInController(new AdditionalInitialization(){

            protected OperationContext.Type getType() {
                return OperationContext.Type.MANAGEMENT;
            }
        }, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        System.out.println(marshalled);
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/Modeshape.xsd");
        System.out.println(marshalled);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                if (!exception.getMessage().contains("cvc-enumeration-valid") && !exception.getMessage().contains("cvc-type")) {
                    Assert.fail((String)exception.getMessage());
                }
            }
        });
        validator.validate(source);
    }

    @Test
    public void testParseSubsystem() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        List operations = super.parse(subsystemXml);
        junit.framework.Assert.assertEquals((int)7, (int)operations.size());
        ModelNode addSubsystem = (ModelNode)operations.get(0);
        junit.framework.Assert.assertEquals((String)"add", (String)addSubsystem.get("operation").asString());
        PathAddress addr = PathAddress.pathAddress((ModelNode)addSubsystem.get("address"));
        junit.framework.Assert.assertEquals((int)1, (int)addr.size());
        PathElement element = addr.getElement(0);
        junit.framework.Assert.assertEquals((String)"subsystem", (String)element.getKey());
        junit.framework.Assert.assertEquals((String)"modeshape", (String)element.getValue());
    }

    @Test
    public void testAddRemoveRepository() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")});
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("repository");
        ModelNode result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List<String> opNames = TestModeShapeConfiguration.getList(result);
        junit.framework.Assert.assertEquals((int)2, (int)opNames.size());
        String[] ops = new String[]{"sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops), opNames);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("repository", "myrepository"));
        addOp.get("jndi-name").set("jcr:local:myrepository");
        result = services.executeOperation(addOp);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        opNames = TestModeShapeConfiguration.getList(result);
        junit.framework.Assert.assertEquals((int)3, (int)opNames.size());
        String[] ops2 = new String[]{"myrepository", "sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops2), opNames);
    }

    private KernelServices buildSubsystem() throws IOException, FileNotFoundException, Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        KernelServices services = super.installInController(subsystemXml);
        return services;
    }

    private static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }
}

