/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.Properties;
import javax.jcr.RepositoryException;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;

public class SequencerService
implements Service<JcrRepository> {
    private final InjectedValue<JcrEngine> jcrEngineInjector = new InjectedValue();
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private final Properties sequencerProperties;
    private final String repositoryName;

    public SequencerService(String repositoryName, Properties sequencerProperties) {
        this.repositoryName = repositoryName;
        this.sequencerProperties = sequencerProperties;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    private JcrEngine getJcrEngine() {
        return (JcrEngine)this.jcrEngineInjector.getValue();
    }

    public void start(StartContext arg0) throws StartException {
        JcrEngine engine = this.getJcrEngine();
        JcrRepository repository = null;
        try {
            repository = engine.getRepository(this.repositoryName);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        RepositoryConfiguration repositoryConfig = repository.getConfiguration();
        Editor editor = repositoryConfig.edit();
        EditableDocument sequencing = editor.getOrCreateDocument("sequencing");
        EditableArray sequencers = sequencing.setArray("sequencers");
        EditableDocument seq = Schematic.newDocument();
        for (String key : this.sequencerProperties.stringPropertyNames()) {
            seq.set(key, (Object)this.sequencerProperties.getProperty(key));
        }
        sequencers.addValue((Object)seq);
        Changes changes = editor.getChanges();
        Problems validationResults = repositoryConfig.validate(changes);
        if (validationResults.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, validationResults.errorCount(), validationResults.toString()});
            throw new StartException(msg);
        }
        try {
            engine.update(this.repositoryName, changes);
        }
        catch (ConfigurationException e) {
            throw new StartException((Throwable)e);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext arg0) {
    }

    public InjectedValue<JcrEngine> getJcrEngineInjector() {
        return this.jcrEngineInjector;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }
}

