/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.add("subsystem", "modeshape");
        subsystem.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(subsystem);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> repositories = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODESHAPE_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case REPOSITORY: {
                            this.parseRepository(reader, subsystem, repositories);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        list.addAll(repositories);
    }

    private void parseRepository(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> repositories) throws XMLStreamException {
        ModelNode repositoryAddress = address.clone();
        ModelNode repository = Util.getEmptyOperation((String)"add", (ModelNode)repositoryAddress);
        String repositoryName = null;
        if (reader.getAttributeCount() > 0) {
            block29: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        repositoryName = attrValue;
                        repositoryAddress.add("repository", attrValue);
                        repositoryAddress.protect();
                        repository.get("operation").set("add");
                        repository.get("address").set(repositoryAddress);
                        repositories.add(repository);
                        continue block29;
                    }
                    case CACHE_NAME: {
                        ModelAttributes.CACHE_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.CACHE_CONTAINER.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case JNDI_NAME: {
                        ModelAttributes.JNDI_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case ENABLE_MONITORING: {
                        ModelAttributes.ENABLE_MONITORING.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case SECURITY_DOMAIN: {
                        ModelAttributes.SECURITY_DOMAIN.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case ANONYMOUS_ROLES: {
                        for (String role : reader.getListAttributeValue(i)) {
                            repository.get("anonymous-roles").add(role);
                        }
                        continue block29;
                    }
                    case ANONYMOUS_USERNAME: {
                        ModelAttributes.ANONYMOUS_USERNAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case USE_ANONYMOUS_IF_AUTH_FAILED: {
                        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case CLUSTER_STACK: {
                        ModelAttributes.CLUSTER_STACK.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    case CLUSTER_NAME: {
                        ModelAttributes.CLUSTER_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block29;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        ModelNode indexStorage = null;
        ModelNode binaryStorage = null;
        List<Object> sequencers = new ArrayList();
        block31: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKSPACES: {
                    this.parseWorkspaces(reader, address, repository);
                    continue block31;
                }
                case INDEXING: {
                    this.parseIndexing(reader, address, repository);
                    continue block31;
                }
                case RAM_INDEX_STORAGE: {
                    indexStorage = this.parseRamIndexStorage(reader, repositoryName);
                    continue block31;
                }
                case LOCAL_FILE_INDEX_STORAGE: {
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "add-local-file-index-storage", "local-file-index-storage");
                    continue block31;
                }
                case MASTER_FILE_INDEX_STORAGE: {
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "add-master-file-index-storage", "master-file-index-storage");
                    continue block31;
                }
                case SLAVE_FILE_INDEX_STORAGE: {
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "add-slave-file-index-storage", "slave-file-index-storage");
                    continue block31;
                }
                case CACHE_INDEX_STORAGE: {
                    indexStorage = this.parseCacheIndexStorage(reader, repositoryName);
                    continue block31;
                }
                case CUSTOM_INDEX_STORAGE: {
                    indexStorage = this.parseCustomIndexStorage(reader, repositoryName);
                    continue block31;
                }
                case FILE_BINARY_STORAGE: {
                    binaryStorage = this.parseFileBinaryStorage(reader, repositoryName);
                    continue block31;
                }
                case DB_BINARY_STORAGE: {
                    binaryStorage = this.parseDatabaseBinaryStorage(reader, repositoryName);
                    continue block31;
                }
                case CACHE_BINARY_STORAGE: {
                    binaryStorage = this.parseCacheBinaryStorage(reader, repositoryName);
                    continue block31;
                }
                case CUSTOM_BINARY_STORAGE: {
                    binaryStorage = this.parseCustomBinaryStorage(reader, repositoryName);
                    continue block31;
                }
                case AUTHENTICATORS: {
                    this.parseAuthenticators(reader, address, repository);
                    continue block31;
                }
                case SEQUENCERS: {
                    sequencers = this.parseSequencers(reader, address, repositoryName);
                    continue block31;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (indexStorage != null) {
            repositories.add(indexStorage);
        }
        if (binaryStorage != null) {
            repositories.add(binaryStorage);
        }
        repositories.addAll(sequencers);
    }

    private void parseWorkspaces(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case ALLOW_WORKSPACE_CREATION: {
                        ModelAttributes.ALLOW_WORKSPACE_CREATION.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case DEFAULT_WORKSPACE: {
                        ModelAttributes.DEFAULT_WORKSPACE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKSPACE: {
                    this.parseWorkspace(reader, repository);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseWorkspace(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        repository.get("predefined-workspace-names").add(attrValue);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute element = Attribute.forName(attrName);
                switch (element) {
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block11;
                    }
                    default: {
                        if (attrName.startsWith("hibernate")) {
                            repository.get(attrName).set(attrValue);
                            continue block11;
                        }
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
    }

    private ModelNode parseRamIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-ram-index-storage");
        storage.get("index-storage-type").set("ram-index-storage");
        if (reader.getAttributeCount() > 0) {
            block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute element = Attribute.forName(attrName);
                switch (element) {
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block10;
                    }
                    default: {
                        storage.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index-storage", "INDEXES");
        return storage;
    }

    private ModelNode parseFileIndexStorage(XMLExtendedStreamReader reader, String repositoryName, String operationName, String name) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set(operationName);
        storage.get("index-storage-type").set(name);
        if (reader.getAttributeCount() > 0) {
            block22: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case PATH: {
                        ModelAttributes.PATH.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ACCESS_TYPE: {
                        ModelAttributes.ACCESS_TYPE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case LOCKING_STRATEGY: {
                        ModelAttributes.LOCKING_STRATEGY.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case REFRESH_PERIOD: {
                        ModelAttributes.REFRESH_PERIOD.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case COPY_BUFFER_SIZE: {
                        ModelAttributes.COPY_BUFFER_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case SOURCE_PATH: {
                        ModelAttributes.SOURCE_PATH.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case SOURCE_RELATIVE_TO: {
                        ModelAttributes.SOURCE_RELATIVE_TO.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case CONNECTION_FACTORY_JNDI_NAME: {
                        ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case QUEUE_JNDI_NAME: {
                        ModelAttributes.QUEUE_JNDI_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block22;
                    }
                    default: {
                        storage.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index-storage", "INDEXES");
        return storage;
    }

    private ModelNode parseCacheIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-cache-index-storage");
        storage.get("index-storage-type").set("cache-index-storage");
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case LOCK_CACHE_NAME: {
                        ModelAttributes.LOCK_CACHE_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case DATA_CACHE_NAME: {
                        ModelAttributes.DATA_CACHE_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case META_CACHE_NAME: {
                        ModelAttributes.METADATA_CACHE_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case CACHE_CONTAINER_JNDI_NAME: {
                        ModelAttributes.CACHE_CONTAINER_JNDI_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        storage.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index-storage", "INDEXES");
        return storage;
    }

    private ModelNode parseCustomIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-custom-index-storage");
        storage.get("index-storage-type").set("custom-index-storage");
        if (reader.getAttributeCount() > 0) {
            block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block14;
                    }
                    default: {
                        storage.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("index-storage", "INDEXES");
        return storage;
    }

    private ModelNode parseFileBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-file-binary-storage");
        storage.get("binary-storage-type").set("file-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case PATH: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("binary-storage", "BINARIES");
        return storage;
    }

    private ModelNode parseCacheBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-cache-binary-storage");
        storage.get("binary-storage-type").set("cache-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case DATA_CACHE_NAME: {
                        ModelAttributes.DATA_CACHE_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case META_CACHE_NAME: {
                        ModelAttributes.METADATA_CACHE_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.CACHE_CONTAINER.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("binary-storage", "BINARIES");
        return storage;
    }

    private ModelNode parseDatabaseBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-db-binary-storage");
        storage.get("binary-storage-type").set("db-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case DATA_SOURCE_JNDI_NAME: {
                        ModelAttributes.DATA_SOURCE_JNDI_NAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("binary-storage", "BINARIES");
        return storage;
    }

    private ModelNode parseCustomBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storage = new ModelNode();
        storage.get("operation").set("add-custom-binary-storage");
        storage.get("binary-storage-type").set("custom-index-storage");
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storage, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        storage.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        storage.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("binary-storage", "BINARIES");
        return storage;
    }

    private void parseAuthenticators(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATOR: {
                    this.parseAuthenticator(reader, repository);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthenticator(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            ModelNode authenticator = new ModelNode();
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        ModelAttributes.NAME.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        if (authenticator.has("name")) continue block5;
                        ModelAttributes.NAME.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        authenticator.get(attrName).set(attrValue);
                    }
                }
            }
            if (authenticator.has("name")) {
                repository.get("authenticators").add(authenticator);
            }
        }
        this.requireNoElements(reader);
    }

    private List<ModelNode> parseSequencers(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> sequencers = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SEQUENCER: {
                    this.parseSequencer(reader, repositoryName, sequencers);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return sequencers;
    }

    private void parseSequencer(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> sequencers) throws XMLStreamException {
        ModelNode sequencer = new ModelNode();
        sequencer.get("operation").set("add");
        String name = null;
        sequencers.add(sequencer);
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block9;
                    }
                    case PATH_EXPRESSION: {
                        ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case CLASSNAME: {
                        ModelAttributes.SEQUENCER_CLASSNAME.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        if (name != null) continue block9;
                        name = attrValue;
                        continue block9;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        sequencer.get(attrName).set(attrValue);
                    }
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATH_EXPRESSION: {
                    String value = reader.getElementText();
                    ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(value, sequencer, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        sequencer.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("sequencer", name);
    }

    protected void requireNoElements(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

