/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.jboss.service.BinaryStorage;

public class BinaryStorageService
implements Service<BinaryStorage> {
    private final Injector<CacheContainer> binaryManagerInjector;
    private final InjectedValue<String> binaryStorageBasePathInjector = new InjectedValue();
    private final EditableDocument binaryConfig;
    protected final BinaryStorage binaryStorage;

    public BinaryStorageService(String repositoryName, EditableDocument binaryConfig) {
        this.binaryConfig = binaryConfig;
        this.binaryStorage = new BinaryStorage(repositoryName, (Document)binaryConfig);
        this.binaryManagerInjector = new Injector<CacheContainer>(){

            public void inject(CacheContainer value) throws InjectionException {
                BinaryStorageService.this.binaryStorage.setCacheContainer(value);
            }

            public void uninject() {
                BinaryStorageService.this.binaryStorage.setCacheContainer(null);
            }
        };
    }

    public String getRepositoryName() {
        return this.binaryStorage.getRepositoryName();
    }

    private String getBinaryStorageBasePath() {
        return this.appendDirDelim((String)this.binaryStorageBasePathInjector.getOptionalValue());
    }

    private String appendDirDelim(String value) {
        if (value != null && value.endsWith("/")) {
            value = value + "/";
        }
        return value;
    }

    public InjectedValue<String> getBinaryStorageBasePathInjector() {
        return this.binaryStorageBasePathInjector;
    }

    public Injector<CacheContainer> getBinaryCacheManagerInjector() {
        return this.binaryManagerInjector;
    }

    public BinaryStorage getValue() throws IllegalStateException, IllegalArgumentException {
        return this.binaryStorage;
    }

    public void start(StartContext arg0) {
        String relativePath;
        String binaryStorageBasePath = this.getBinaryStorageBasePath();
        if (binaryStorageBasePath != null && (relativePath = this.binaryConfig.getString("directory")) != null) {
            this.binaryConfig.set("directory", (Object)(binaryStorageBasePath + relativePath));
        }
    }

    public void stop(StopContext arg0) {
    }
}

