/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            for (Property entry : model.get("repository").asPropertyList()) {
                String repositoryName = entry.getName();
                ModelNode repository = entry.getValue();
                this.writeRepositoryConfiguration(writer, repository, repositoryName);
            }
        }
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode repository, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.REPOSITORY.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        this.writeAttribute(writer, repository, ModelAttributes.CACHE_NAME);
        this.writeAttribute(writer, repository, ModelAttributes.CACHE_CONTAINER);
        this.writeAttribute(writer, repository, ModelAttributes.JNDI_NAME);
        this.writeAttribute(writer, repository, ModelAttributes.ENABLE_MONITORING);
        this.writeAttribute(writer, repository, ModelAttributes.SECURITY_DOMAIN);
        this.writeAttributeAsList(writer, repository, ModelAttributes.ANONYMOUS_ROLES);
        this.writeAttribute(writer, repository, ModelAttributes.ANONYMOUS_USERNAME);
        this.writeAttribute(writer, repository, ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED);
        this.writeAttribute(writer, repository, ModelAttributes.CLUSTER_NAME);
        this.writeAttribute(writer, repository, ModelAttributes.CLUSTER_STACK);
        this.writeWorkspaces(writer, repository);
        this.writeIndexing(writer, repository);
        this.writeIndexStorage(writer, repository);
        this.writeBinaryStorage(writer, repository);
        this.writeAuthenticators(writer, repository);
        this.writeSequencing(writer, repository);
        this.writeTextExtraction(writer, repository);
        writer.writeEndElement();
    }

    private void writeWorkspaces(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.DEFAULT_WORKSPACE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.DEFAULT_WORKSPACE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ALLOW_WORKSPACE_CREATION.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.ALLOW_WORKSPACE_CREATION.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (this.has(repository, "predefined-workspace-names")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelNode names = repository.get("predefined-workspace-names");
            if (names.isDefined()) {
                for (ModelNode workspace : repository.get("predefined-workspace-names").asList()) {
                    writer.writeStartElement(Element.WORKSPACE.getLocalName());
                    String name = workspace.asString();
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    writer.writeEndElement();
                }
            }
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeIndexing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        for (String key : repository.keys()) {
            if ("rebuild-indexes-upon-startup".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.REBUILD_INDEXES_UPON_STARTUP, Element.INDEXING, started);
                continue;
            }
            if ("indexing-analyzer-classname".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ANALYZER_CLASSNAME, Element.INDEXING, started);
                continue;
            }
            if ("indexing-analyzer-module".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ANALYZER_MODULE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-async-thread-pool-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ASYNC_THREAD_POOL_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-async-max-queue-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ASYNC_MAX_QUEUE_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-batch-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.BATCH_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-mode".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.MODE, Element.INDEXING, started);
                continue;
            }
            if ("system-content-indexing-mode".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.SYSTEM_CONTENT_MODE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-reader-strategy".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.READER_STRATEGY, Element.INDEXING, started);
                continue;
            }
            if ("indexing-thread-pool".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.THREAD_POOL, Element.INDEXING, started);
                continue;
            }
            if (!key.startsWith("hibernate")) continue;
            writer.writeAttribute(key, repository.get(key).asString());
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private boolean startIfNeeded(XMLExtendedStreamWriter writer, Element name, boolean alreadyStarted) throws XMLStreamException {
        if (!alreadyStarted) {
            writer.writeStartElement(name.getLocalName());
        }
        return true;
    }

    private void writeIndexStorageAttributes(XMLExtendedStreamWriter writer, ModelNode storage, Element element, boolean started) throws XMLStreamException {
        for (String key : storage.keys()) {
            if ("index-storage-type".equals(key)) continue;
            if ("index-format".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.INDEX_FORMAT, element, started);
                continue;
            }
            if ("path".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.PATH, element, started);
                continue;
            }
            if ("relative-to".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.RELATIVE_TO, element, started);
                continue;
            }
            if ("source-path".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.SOURCE_PATH, element, started);
                continue;
            }
            if ("source-relative-to".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.SOURCE_RELATIVE_TO, element, started);
                continue;
            }
            if ("access-type".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.ACCESS_TYPE, element, started);
                continue;
            }
            if ("locking-strategy".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.LOCKING_STRATEGY, element, started);
                continue;
            }
            if ("refresh-period".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.REFRESH_PERIOD, element, started);
                continue;
            }
            if ("copy-buffer-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.COPY_BUFFER_SIZE, element, started);
                continue;
            }
            if ("connection-factory-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CONNECTION_FACTORY_JNDI_NAME, element, started);
                continue;
            }
            if ("queue-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.QUEUE_JNDI_NAME, element, started);
                continue;
            }
            if ("lock-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.LOCK_CACHE_NAME, element, started);
                continue;
            }
            if ("data-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.DATA_CACHE_NAME, element, started);
                continue;
            }
            if ("metadata-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.METADATA_CACHE_NAME, element, started);
                continue;
            }
            if ("cache-container-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CACHE_CONTAINER_JNDI_NAME, element, started);
                continue;
            }
            if ("data-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.DATA_CACHE_NAME, element, started);
                continue;
            }
            if ("classname".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CLASSNAME, element, started);
                continue;
            }
            if ("module".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CLASSNAME, element, started);
                continue;
            }
            writer.writeAttribute(key, storage.get(key).asString());
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeIndexStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "index-storage", "INDEXES")) {
            ModelNode indexStorage = repository.get(new String[]{"index-storage", "INDEXES"});
            String storageType = indexStorage.get("index-storage-type").asString();
            if ("ram-index-storage".equals(storageType)) {
                writer.writeStartElement(Element.RAM_INDEX_STORAGE.getLocalName());
                this.writeIndexStorageAttributes(writer, indexStorage, Element.RAM_INDEX_STORAGE, true);
            } else if ("local-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorage, Element.LOCAL_FILE_INDEX_STORAGE, false);
            } else if ("master-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorage, Element.MASTER_FILE_INDEX_STORAGE, false);
            } else if ("slave-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorage, Element.SLAVE_FILE_INDEX_STORAGE, false);
            } else if ("cache-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorage, Element.CACHE_INDEX_STORAGE, false);
            } else if ("custom-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorage, Element.CUSTOM_INDEX_STORAGE, false);
            }
        }
    }

    private void writeBinaryStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "binary-storage", "BINARIES")) {
            ModelNode binaryStorage = repository.get("binary-storage");
            String storageType = binaryStorage.get("binary-storage-type").asString();
            if ("file-binary-storage".equals(storageType)) {
                ModelNode storage = binaryStorage.get("file-binary-storage");
                writer.writeStartElement(Element.FILE_BINARY_STORAGE.getLocalName());
                this.writeAttribute(writer, storage, ModelAttributes.MINIMUM_BINARY_SIZE);
                this.writeAttribute(writer, storage, ModelAttributes.PATH);
                this.writeAttribute(writer, storage, ModelAttributes.RELATIVE_TO);
                writer.writeEndElement();
            } else if ("cache-binary-storage".equals(storageType)) {
                ModelNode storage = binaryStorage.get("cache-binary-storage");
                writer.writeStartElement(Element.CACHE_BINARY_STORAGE.getLocalName());
                this.writeAttribute(writer, storage, ModelAttributes.MINIMUM_BINARY_SIZE);
                this.writeAttribute(writer, storage, ModelAttributes.DATA_CACHE_NAME);
                this.writeAttribute(writer, storage, ModelAttributes.METADATA_CACHE_NAME);
                this.writeAttribute(writer, storage, ModelAttributes.CACHE_CONTAINER);
                writer.writeEndElement();
            } else if ("db-binary-storage".equals(storageType)) {
                ModelNode storage = binaryStorage.get("db-binary-storage");
                writer.writeStartElement(Element.DB_BINARY_STORAGE.getLocalName());
                this.writeAttribute(writer, storage, ModelAttributes.MINIMUM_BINARY_SIZE);
                this.writeAttribute(writer, storage, ModelAttributes.DATA_SOURCE_JNDI_NAME);
                writer.writeEndElement();
            } else if ("custom-binary-storage".equals(storageType)) {
                ModelNode storage = binaryStorage.get("custom-binary-storage");
                writer.writeStartElement(Element.CUSTOM_BINARY_STORAGE.getLocalName());
                this.writeAttribute(writer, storage, ModelAttributes.MINIMUM_BINARY_SIZE);
                for (String key : storage.keys()) {
                    if (key.equals("classname")) {
                        this.writeAttribute(writer, storage, ModelAttributes.CLASSNAME);
                        continue;
                    }
                    if (key.equals("module")) {
                        this.writeAttribute(writer, storage, ModelAttributes.MODULE);
                        continue;
                    }
                    writer.writeAttribute(key, storage.get(key).asString());
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeAuthenticators(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "authenticators")) {
            ModelNode indexing = repository.get("authenticators");
            writer.writeStartElement(Element.AUTHENTICATORS.getLocalName());
            for (String key : indexing.keys()) {
                if ("name".equals(key)) {
                    ModelAttributes.NAME.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                if ("classname".equals(key)) {
                    ModelAttributes.CLASSNAME.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                if ("module".equals(key)) {
                    ModelAttributes.MODULE.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                ModelNode param = indexing.get(key);
                writer.writeAttribute(key, param.asString());
            }
            writer.writeEndElement();
        }
    }

    private void writeSequencing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "sequencer")) {
            writer.writeStartElement(Element.SEQUENCERS.getLocalName());
            for (Property sequencer : repository.get("sequencer").asPropertyList()) {
                writer.writeStartElement(Element.SEQUENCER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), sequencer.getName());
                ModelNode prop = sequencer.getValue();
                ModelAttributes.SEQUENCER_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                List pathExpressions = prop.get("path-expressions").asList();
                switch (pathExpressions.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ModelNode pathExpression = (ModelNode)pathExpressions.iterator().next();
                        writer.writeAttribute(Attribute.PATH_EXPRESSION.getLocalName(), pathExpression.asString());
                        break;
                    }
                    default: {
                        for (ModelNode pathExpr : pathExpressions) {
                            writer.writeStartElement(Element.PATH_EXPRESSION.getLocalName());
                            writer.writeCharacters(pathExpr.asString());
                            writer.writeEndElement();
                        }
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeTextExtraction(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "text-extractor")) {
            writer.writeStartElement(Element.TEXT_EXTRACTORS.getLocalName());
            for (Property extractor : repository.get("text-extractor").asPropertyList()) {
                writer.writeStartElement(Element.TEXT_EXTRACTOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), extractor.getName());
                ModelNode prop = extractor.getValue();
                ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.isDefined() && node.has(name) && node.get(name).isDefined();
    }

    private boolean has(ModelNode node, String ... names) {
        for (String name : names) {
            if (!node.isDefined() || !node.has(name)) {
                return false;
            }
            node = node.get(name);
        }
        return true;
    }

    private boolean startAndWriteAttribute(XMLExtendedStreamWriter writer, ModelNode node, SimpleAttributeDefinition modelAttribute, Element name, boolean started) throws XMLStreamException {
        assert (modelAttribute.getXmlName() != null);
        boolean result = started;
        if (modelAttribute.isMarshallable(node, false)) {
            result = this.startIfNeeded(writer, name, started);
            modelAttribute.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        }
        return result;
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, ModelNode node, SimpleAttributeDefinition modelAttribute) throws XMLStreamException {
        assert (modelAttribute.getXmlName() != null);
        if (modelAttribute.isMarshallable(node, false)) {
            modelAttribute.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        }
    }

    private void writeAttributeAsList(XMLExtendedStreamWriter writer, ModelNode node, ListAttributeDefinition modelAttribute) throws XMLStreamException {
        if (modelAttribute.isMarshallable(node, false)) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = node.get(modelAttribute.getName()).asList().iterator();
            if (iter.hasNext()) {
                sb.append(((ModelNode)iter.next()).asString());
                while (iter.hasNext()) {
                    sb.append(" ").append(((ModelNode)iter.next()).asString());
                }
                writer.writeAttribute(modelAttribute.getXmlName(), sb.toString());
            }
        }
    }
}

