/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCacheIndexStorage
extends AbstractAddIndexStorage {
    public static final AddCacheIndexStorage INSTANCE = new AddCacheIndexStorage();

    private AddCacheIndexStorage() {
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage) throws OperationFailedException {
        String lockCache = ModelAttributes.LOCK_CACHE_NAME.resolveModelAttribute(context, storage).asString();
        String dataCache = ModelAttributes.DATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
        String metaCache = ModelAttributes.METADATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
        String containerJndiName = ModelAttributes.CACHE_CONTAINER_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        int chunkSize = ModelAttributes.CHUNK_SIZE.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("type", (Object)"infinispan");
        indexStorage.set("lockCacheName", (Object)lockCache);
        indexStorage.set("dataCacheName", (Object)dataCache);
        indexStorage.set("metadataCacheName", (Object)metaCache);
        indexStorage.set("chunkSizeInBytes", (Object)chunkSize);
        indexStorage.set("cacheConfiguration", (Object)containerJndiName);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCacheIndexStorage.populate(operation, model, "cache-index-storage", ModelAttributes.CACHE_INDEX_STORAGE_ATTRIBUTES);
    }
}

