/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveBinaryStorage
extends AbstractRemoveStepHandler {
    protected static final Logger log = Logger.getLogger((String)RemoveBinaryStorage.class.getPackage().getName());
    public static final RemoveBinaryStorage INSTANCE = new RemoveBinaryStorage();

    private RemoveBinaryStorage() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String repositoryName = serviceAddress.getElement(1).getValue();
        ServiceName serviceName = ModeShapeServiceNames.binaryStorageServiceName(repositoryName);
        context.removeService(serviceName);
        if (model.has("relative-to") && model.get("relative-to").asString().contains("jboss.server.data.dir")) {
            ServiceName dirServiceName = ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName);
            context.removeService(dirServiceName);
        }
        String service = serviceAddress.getLastElement().getValue();
        log.debugf("binary storage '%s' removed for repository '%s'", (Object)service, (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

