/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.jcr.RepositoryConfiguration;

public class IndexStorage {
    private final String repositoryName;
    private final EditableDocument queryConfig;

    IndexStorage(String repositoryName, EditableDocument queryConfig) {
        this.repositoryName = repositoryName;
        this.queryConfig = queryConfig;
    }

    static IndexStorage defaultStorage(String repositoryName, String dataDirPath) {
        EditableDocument query = Schematic.newDocument();
        EditableDocument indexing = query.getOrCreateDocument("indexing");
        EditableDocument indexStorage = query.getOrCreateDocument("indexStorage");
        EditableDocument backend = indexing.getOrCreateDocument("backend");
        query.set("rebuildUponStartup", (Object)RepositoryConfiguration.QueryRebuild.IF_MISSING.toString().toLowerCase());
        backend.set("type", (Object)"lucene");
        indexStorage.set("type", (Object)"filesystem");
        indexStorage.set("location", (Object)(dataDirPath + "/" + repositoryName + "/indexes"));
        return new IndexStorage(repositoryName, query);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public EditableDocument getQueryConfiguration() {
        return this.queryConfig;
    }
}

