/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCacheIndexStorage
extends AbstractAddIndexStorage {
    public static final AddCacheIndexStorage INSTANCE = new AddCacheIndexStorage();

    private AddCacheIndexStorage() {
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage) throws OperationFailedException {
        indexStorage.set("type", (Object)"infinispan");
        String containerJndiName = ModelAttributes.CACHE_CONTAINER_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        indexStorage.set("cacheConfiguration", (Object)containerJndiName);
        int chunkSize = ModelAttributes.CHUNK_SIZE.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("chunkSizeInBytes", (Object)chunkSize);
        if (storage.hasDefined("lock-cache-name")) {
            String lockCache = ModelAttributes.LOCK_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("lockCacheName", (Object)lockCache);
        }
        if (storage.hasDefined("data-cache-name")) {
            String dataCache = ModelAttributes.DATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("dataCacheName", (Object)dataCache);
        }
        if (storage.hasDefined("metadata-cache-name")) {
            String metaCache = ModelAttributes.METADATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("metadataCacheName", (Object)metaCache);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCacheIndexStorage.populate(operation, model, "cache-index-storage", ModelAttributes.CACHE_INDEX_STORAGE_ATTRIBUTES);
    }
}

