/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.modeshape.jboss.subsystem.ModeShapeBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCacheBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCacheIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCustomBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCustomIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeDatabaseBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeFileBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeLocalFileIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeMasterFileIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeRamIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeRepositoryResource;
import org.modeshape.jboss.subsystem.ModeShapeRootResource;
import org.modeshape.jboss.subsystem.ModeShapeSequencerResource;
import org.modeshape.jboss.subsystem.ModeShapeSlaveFileIndexStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemXMLWriter;
import org.modeshape.jboss.subsystem.ModeShapeTextExtractorResource;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "modeshape";
    static final String DATA_DIR_VARIABLE = "jboss.server.data.dir";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final String RESOURCE_NAME = ModeShapeExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modeshape");
    static final PathElement REPOSITORY_PATH = PathElement.pathElement((String)"repository");
    static final PathElement SEQUENCER_PATH = PathElement.pathElement((String)"sequencer");
    static final PathElement TEXT_EXTRACTOR_PATH = PathElement.pathElement((String)"text-extractor");
    static final PathElement INDEX_STORAGE_PATH = PathElement.pathElement((String)"configuration", (String)"index-storage");
    static final PathElement RAM_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"ram-index-storage");
    static final PathElement LOCAL_FILE_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"local-file-index-storage");
    static final PathElement MASTER_FILE_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"master-file-index-storage");
    static final PathElement SLAVE_FILE_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"slave-file-index-storage");
    static final PathElement CACHE_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"cache-index-storage");
    static final PathElement CUSTOM_INDEX_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"custom-index-storage");
    static final PathElement BINARY_STORAGE_PATH = PathElement.pathElement((String)"configuration", (String)"binary-storage");
    static final PathElement FILE_BINARY_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"file-binary-storage");
    static final PathElement CACHE_BINARY_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"cache-binary-storage");
    static final PathElement DB_BINARY_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"db-binary-storage");
    static final PathElement CUSTOM_BINARY_STORAGE_PATH = PathElement.pathElement((String)"storage-type", (String)"custom-binary-storage");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModeShapeExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2);
        registration.registerXMLElementWriter((XMLElementWriter)new ModeShapeSubsystemXMLWriter());
        ManagementResourceRegistration modeShapeSubsystem = registration.registerSubsystemModel((ResourceDefinition)ModeShapeRootResource.INSTANCE);
        ManagementResourceRegistration repositorySubmodel = modeShapeSubsystem.registerSubModel((ResourceDefinition)ModeShapeRepositoryResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeSequencerResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeTextExtractorResource.INSTANCE);
        ManagementResourceRegistration indexStorageSubmodel = repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeRamIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeMasterFileIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeSlaveFileIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCacheIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomIndexStorageResource.INSTANCE);
        indexStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeLocalFileIndexStorageResource.INSTANCE);
        ManagementResourceRegistration binaryStorageSubmodel = repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeFileBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCacheBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeDatabaseBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomBinaryStorageResource.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }
}

