/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveSequencer
extends AbstractRemoveStepHandler {
    private static final Logger log = Logger.getLogger((String)RemoveSequencer.class.getPackage().getName());
    public static final RemoveSequencer INSTANCE = new RemoveSequencer();

    private RemoveSequencer() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String sequencerName = serviceAddress.getLastElement().getValue();
        String repositoryName = serviceAddress.getElement(1).getValue();
        ServiceName serviceName = ModeShapeServiceNames.sequencerServiceName(repositoryName, sequencerName);
        context.removeService(serviceName);
        log.debugf("sequencer '%s' removed for repository '%s'", (Object)sequencerName, (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

