/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.jcr.RepositoryConfiguration;

public class IndexStorage {
    private final EditableDocument queryConfig;
    private CacheContainer cacheContainer;

    IndexStorage(EditableDocument queryConfig) {
        this.queryConfig = queryConfig;
    }

    void setDefaultValues(String dataDirPath) {
        this.queryConfig.set("rebuildUponStartup", (Object)RepositoryConfiguration.QueryRebuild.IF_MISSING.toString().toLowerCase());
        EditableDocument indexing = this.queryConfig.getOrCreateDocument("indexing");
        EditableDocument backend = indexing.getOrCreateDocument("backend");
        backend.set("type", (Object)"lucene");
        EditableDocument indexStorage = this.queryConfig.getOrCreateDocument("indexStorage");
        indexStorage.set("type", (Object)"filesystem");
        indexStorage.set("location", (Object)(dataDirPath + "/indexes"));
    }

    boolean useDefaultValues() {
        return !this.queryConfig.containsField("indexStorage");
    }

    public EditableDocument getQueryConfiguration() {
        return this.queryConfig;
    }

    CacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    void setCacheContainer(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }
}

