/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import javax.transaction.TransactionManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.transaction.lookup.JBossTransactionManagerLookup;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.logging.Logger;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.service.IndexStorage;
import org.modeshape.jboss.service.IndexStorageService;
import org.modeshape.jboss.service.ReferenceFactoryService;
import org.modeshape.jboss.service.RepositoryService;
import org.modeshape.jboss.subsystem.ModeShapeJndiNames;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

public class AddRepository
extends AbstractAddStepHandler {
    public static final AddRepository INSTANCE = new AddRepository();

    private AddRepository() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.REPOSITORY_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    private ModelNode attribute(OperationContext context, ModelNode model, AttributeDefinition defn) throws OperationFailedException {
        assert (defn.getDefaultValue() != null && defn.getDefaultValue().isDefined());
        return defn.resolveModelAttribute(context, model);
    }

    private String attribute(OperationContext context, ModelNode model, AttributeDefinition defn, String defaultValue) throws OperationFailedException {
        ModelNode value = defn.resolveModelAttribute(context, model);
        return value.isDefined() ? value.asString() : defaultValue;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getLastElement().getValue();
        String cacheName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CACHE_NAME, repositoryName);
        String clusterChannelName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CLUSTER_NAME, null);
        String clusterStackName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CLUSTER_STACK, null);
        boolean enableMonitoring = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ENABLE_MONITORING).asBoolean();
        String namedContainer = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CACHE_CONTAINER, "modeshape");
        EditableDocument configDoc = Schematic.newDocument();
        configDoc.set("name", (Object)repositoryName);
        configDoc.set("jndiName", (Object)"");
        String jndiName = "jcr/" + repositoryName;
        String jndiAlias = ModeShapeJndiNames.jndiNameFrom(model, repositoryName);
        if (jndiName.equals(jndiAlias)) {
            jndiAlias = null;
        }
        this.enableMonitoring(enableMonitoring, configDoc);
        this.parseCustomNodeTypes(model, configDoc);
        EditableDocument workspacesDoc = this.parseWorkspaces(context, model, configDoc);
        this.parseStorage(cacheName, configDoc);
        EditableDocument query = this.parseIndexing(context, model, configDoc);
        this.parseSecurity(context, model, configDoc);
        this.parseClustering(clusterChannelName, configDoc);
        RepositoryConfiguration repositoryConfig = new RepositoryConfiguration((Document)configDoc, repositoryName);
        RepositoryService repositoryService = new RepositoryService(repositoryConfig);
        ServiceName repositoryServiceName = ModeShapeServiceNames.repositoryServiceName(repositoryName);
        ServiceBuilder builder = target.addService(repositoryServiceName, (Service)repositoryService);
        builder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, repositoryService.getEngineInjector());
        if (clusterStackName != null) {
            builder.addDependency(ServiceName.JBOSS.append(new String[]{"jgroups", "stack", clusterStackName}), ChannelFactory.class, repositoryService.getChannelFactoryInjector());
        }
        builder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, repositoryService.getTransactionManagerInjector());
        builder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", namedContainer}), CacheContainer.class, repositoryService.getCacheManagerInjector());
        String workspacesCacheContainer = this.attribute(context, model, (AttributeDefinition)ModelAttributes.WORKSPACES_CACHE_CONTAINER, null);
        if (workspacesCacheContainer != null && !workspacesCacheContainer.toLowerCase().equalsIgnoreCase(namedContainer)) {
            builder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", workspacesCacheContainer}), CacheContainer.class, repositoryService.getWorkspacesCacheContainerInjector());
            workspacesDoc.set("cacheConfiguration", (Object)"workspaces");
        }
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, repositoryService.getModuleLoaderInjector());
        builder.addDependency(ModeShapeServiceNames.indexStorageServiceName(repositoryName), IndexStorage.class, repositoryService.getIndexStorageConfigInjector());
        builder.addDependency(ModeShapeServiceNames.binaryStorageServiceName(repositoryName), BinaryStorage.class, repositoryService.getBinaryStorageInjector());
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = repositoryServiceName.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(repositoryServiceName, JcrRepository.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder);
        if (jndiAlias != null) {
            ContextNames.BindInfo aliasInfo = ContextNames.bindInfoFor((String)jndiAlias);
            ServiceName alias = aliasInfo.getBinderServiceName();
            binderBuilder.addAliases(new ServiceName[]{alias});
            Logger.getLogger(((Object)((Object)this)).getClass()).debug("Binding repository '{0}' to JNDI name '{1}' and '{2}'", new Object[]{repositoryName, bindInfo.getAbsoluteJndiName(), aliasInfo.getAbsoluteJndiName()});
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug("Binding repository '{0}' to JNDI name '{1}'", new Object[]{repositoryName, bindInfo.getAbsoluteJndiName()});
        }
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binder.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceName dataDirServiceName = ModeShapeServiceNames.dataDirectoryServiceName(repositoryName);
        ServiceController dataDirServiceController = RelativePathService.addService((ServiceName)dataDirServiceName, (String)("modeshape/" + repositoryName), (String)"jboss.server.data.dir", (ServiceTarget)target);
        newControllers.add(dataDirServiceController);
        builder.addDependency(dataDirServiceName, String.class, repositoryService.getDataDirectoryPathInjector());
        IndexStorageService defaultIndexService = new IndexStorageService(query);
        ServiceBuilder indexBuilder = target.addService(ModeShapeServiceNames.indexStorageServiceName(repositoryName), (Service)defaultIndexService);
        indexBuilder.addDependency(dataDirServiceName, String.class, defaultIndexService.getDataDirectoryPathInjector());
        indexBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        BinaryStorageService defaultBinaryService = new BinaryStorageService(repositoryName);
        ServiceBuilder binaryStorageBuilder = target.addService(ModeShapeServiceNames.binaryStorageServiceName(repositoryName), (Service)defaultBinaryService);
        binaryStorageBuilder.addDependency(dataDirServiceName, String.class, defaultBinaryService.getDataDirectoryPathInjector());
        binaryStorageBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(builder.install());
        newControllers.add(referenceBuilder.install());
        newControllers.add(binderBuilder.install());
        newControllers.add(indexBuilder.install());
        newControllers.add(binaryStorageBuilder.install());
    }

    private void parseClustering(String clusterChannelName, EditableDocument configDoc) {
        if (clusterChannelName != null) {
            EditableDocument clustering = configDoc.getOrCreateDocument("clustering");
            clustering.setString("clusterName", clusterChannelName);
        }
    }

    private void parseSecurity(OperationContext context, ModelNode model, EditableDocument configDoc) throws OperationFailedException {
        EditableDocument security = configDoc.getOrCreateDocument("security");
        EditableDocument jaas = security.getOrCreateDocument("jaas");
        String securityDomain = this.attribute(context, model, (AttributeDefinition)ModelAttributes.SECURITY_DOMAIN).asString();
        jaas.set("policyName", (Object)securityDomain);
        EditableDocument anon = security.getOrCreateDocument("anonymous");
        String anonUsername = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ANONYMOUS_USERNAME).asString();
        boolean useAnonIfFailed = this.attribute(context, model, (AttributeDefinition)ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED).asBoolean();
        anon.set("username", (Object)anonUsername);
        anon.set("useOnFailedLogin", (Object)useAnonIfFailed);
        if (model.hasDefined("anonymous-roles")) {
            for (ModelNode roleNode : model.get("anonymous-roles").asList()) {
                anon.getOrCreateArray("roles").addString(roleNode.asString());
            }
        }
        EditableArray providers = security.getOrCreateArray("providers");
        EditableDocument servlet = Schematic.newDocument();
        servlet.set("classname", (Object)"servlet");
        servlet.set("name", (Object)"Authenticator that uses the Servlet context");
        providers.add((Object)servlet);
    }

    private EditableDocument parseIndexing(OperationContext context, ModelNode model, EditableDocument configDoc) throws OperationFailedException {
        EditableDocument query = configDoc.getOrCreateDocument("query");
        EditableDocument indexing = query.getOrCreateDocument("indexing");
        String analyzerClassname = ModelAttributes.ANALYZER_CLASSNAME.resolveModelAttribute(context, model).asString();
        indexing.set("analyzer", (Object)analyzerClassname);
        if (model.hasDefined("indexing-analyzer-module")) {
            String analyzerClasspath = ModelAttributes.ANALYZER_MODULE.resolveModelAttribute(context, model).asString();
            indexing.set("analyzerClasspath", (Object)analyzerClasspath);
        }
        String indexThreadPool = ModelAttributes.THREAD_POOL.resolveModelAttribute(context, model).asString();
        indexing.set("threadPool", (Object)indexThreadPool);
        int indexBatchSize = ModelAttributes.BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        indexing.set("batchSize", (Object)indexBatchSize);
        String indexReaderStrategy = ModelAttributes.READER_STRATEGY.resolveModelAttribute(context, model).asString();
        indexing.set("readerStrategy", (Object)indexReaderStrategy);
        String indexMode = ModelAttributes.MODE.resolveModelAttribute(context, model).asString();
        indexing.set("mode", (Object)indexMode);
        String systemContentIndexingMode = ModelAttributes.SYSTEM_CONTENT_MODE.resolveModelAttribute(context, model).asString();
        indexing.set("systemContentMode", (Object)systemContentIndexingMode);
        int indexAsyncThreadPoolSize = ModelAttributes.ASYNC_THREAD_POOL_SIZE.resolveModelAttribute(context, model).asInt();
        indexing.set("asyncThreadPoolSize", (Object)indexAsyncThreadPoolSize);
        int indexAsyncMaxQueueSize = ModelAttributes.ASYNC_MAX_QUEUE_SIZE.resolveModelAttribute(context, model).asInt();
        indexing.set("asyncMaxQueueSize", (Object)indexAsyncMaxQueueSize);
        for (String key : model.keys()) {
            if (!key.startsWith("hibernate")) continue;
            indexing.set(key, (Object)model.get(key).asString());
        }
        return query;
    }

    private void parseStorage(String cacheName, EditableDocument configDoc) {
        EditableDocument storage = configDoc.getOrCreateDocument("storage");
        storage.set("cacheName", (Object)cacheName);
        storage.set("transactionManagerLookup", (Object)JBossTransactionManagerLookup.class.getName());
        storage.set("cacheConfiguration", (Object)"content");
    }

    private EditableDocument parseWorkspaces(OperationContext context, ModelNode model, EditableDocument configDoc) throws OperationFailedException {
        EditableDocument initialContentDocument;
        EditableDocument workspacesDoc = configDoc.getOrCreateDocument("workspaces");
        boolean allowWorkspaceCreation = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ALLOW_WORKSPACE_CREATION).asBoolean();
        String defaultWorkspaceName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.DEFAULT_WORKSPACE).asString();
        workspacesDoc.set("allowCreation", (Object)allowWorkspaceCreation);
        workspacesDoc.set("default", (Object)defaultWorkspaceName);
        if (model.hasDefined("predefined-workspace-names")) {
            for (ModelNode name : model.get("predefined-workspace-names").asList()) {
                workspacesDoc.getOrCreateArray("predefined").add((Object)name.asString());
            }
            if (model.hasDefined("workspaces-initial-content")) {
                initialContentDocument = workspacesDoc.getOrCreateDocument("initialContent");
                List workspacesInitialContent = model.get("workspaces-initial-content").asList();
                for (ModelNode initialContent : workspacesInitialContent) {
                    Property initialContentProperty = initialContent.asProperty();
                    initialContentDocument.set(initialContentProperty.getName(), (Object)initialContentProperty.getValue().asString());
                }
            }
        }
        if (model.hasDefined("default-initial-content")) {
            initialContentDocument = workspacesDoc.getOrCreateDocument("initialContent");
            initialContentDocument.set("*", (Object)model.get("default-initial-content").asString());
        }
        return workspacesDoc;
    }

    private void parseCustomNodeTypes(ModelNode model, EditableDocument configDoc) {
        if (model.hasDefined("node-types")) {
            EditableArray nodeTypesArray = configDoc.getOrCreateArray("node-types");
            for (ModelNode nodeType : model.get("node-types").asList()) {
                nodeTypesArray.add((Object)nodeType.asString());
            }
        }
    }

    private void enableMonitoring(boolean enableMonitoring, EditableDocument configDoc) {
        EditableDocument monitoring = configDoc.getOrCreateDocument("monitoring");
        monitoring.set("enabled", (Object)enableMonitoring);
    }
}

