/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveAuthenticator
extends AbstractRemoveStepHandler {
    private static final Logger log = Logger.getLogger((String)RemoveAuthenticator.class.getPackage().getName());
    public static final RemoveAuthenticator INSTANCE = new RemoveAuthenticator();

    private RemoveAuthenticator() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String authenticatorName = serviceAddress.getLastElement().getValue();
        String repositoryName = serviceAddress.getElement(1).getValue();
        ServiceName serviceName = ModeShapeServiceNames.authenticatorServiceName(repositoryName, authenticatorName);
        context.removeService(serviceName);
        log.debugf("authenticator '%s' removed for repository '%s'", (Object)authenticatorName, (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

