/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.add("subsystem", "modeshape");
        subsystem.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(subsystem);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> repositories = new ArrayList<ModelNode>();
        ArrayList<ModelNode> webapps = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODESHAPE_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case REPOSITORY: {
                            this.parseRepository(reader, subsystem, repositories);
                            break block0;
                        }
                        case WEBAPP: {
                            this.parseWebApp(reader, subsystem, webapps);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        list.addAll(webapps);
        list.addAll(repositories);
    }

    private void parseWebApp(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> webapps) throws XMLStreamException {
        ModelNode webappAddress = address.clone();
        ModelNode webapp = Util.getEmptyOperation((String)"add", (ModelNode)webappAddress);
        String webappName = null;
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case NAME: {
                    webappName = attrValue;
                    webappAddress.add("webapp", webappName);
                    webappAddress.protect();
                    webapp.get("operation").set("add");
                    webapp.get("address").set(webappAddress);
                    webapps.add(webapp);
                    continue block5;
                }
                case EXPLODED: {
                    ModelAttributes.EXPLODED.parseAndSetParameter(attrValue, webapp, (XMLStreamReader)reader);
                    continue block5;
                }
                case AUTO_DEPLOY: {
                    ModelAttributes.AUTO_DEPLOY.parseAndSetParameter(attrValue, webapp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.requireNoElements(reader);
    }

    private void parseRepository(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> repositories) throws XMLStreamException {
        ModelNode repositoryAddress = address.clone();
        ModelNode repository = Util.getEmptyOperation((String)"add", (ModelNode)repositoryAddress);
        String repositoryName = null;
        if (reader.getAttributeCount() > 0) {
            block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        repositoryName = attrValue;
                        repositoryAddress.add("repository", attrValue);
                        repositoryAddress.protect();
                        repository.get("operation").set("add");
                        repository.get("address").set(repositoryAddress);
                        repositories.add(repository);
                        continue block36;
                    }
                    case CACHE_NAME: {
                        ModelAttributes.CACHE_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.CACHE_CONTAINER.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case JNDI_NAME: {
                        ModelAttributes.JNDI_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case ENABLE_MONITORING: {
                        ModelAttributes.ENABLE_MONITORING.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case ENABLE_QUERIES: {
                        ModelAttributes.ENABLE_QUERIES.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case SECURITY_DOMAIN: {
                        ModelAttributes.SECURITY_DOMAIN.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case ANONYMOUS_ROLES: {
                        for (String role : reader.getListAttributeValue(i)) {
                            repository.get("anonymous-roles").add(role);
                        }
                        continue block36;
                    }
                    case ANONYMOUS_USERNAME: {
                        ModelAttributes.ANONYMOUS_USERNAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case USE_ANONYMOUS_IF_AUTH_FAILED: {
                        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case CLUSTER_STACK: {
                        ModelAttributes.CLUSTER_STACK.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case CLUSTER_NAME: {
                        ModelAttributes.CLUSTER_NAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case GARBAGE_COLLECTION_THREAD_POOL: {
                        ModelAttributes.GARBAGE_COLLECTION_THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case GARBAGE_COLLECTION_INITIAL_TIME: {
                        ModelAttributes.GARBAGE_COLLECTION_INITIAL_TIME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    case GARBAGE_COLLECTION_INTERVAL: {
                        ModelAttributes.GARBAGE_COLLECTION_INTERVAL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block36;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        ModelNode indexStorage = null;
        ModelNode binaryStorage = null;
        List<Object> sequencers = new ArrayList();
        List<Object> externalSources = new ArrayList();
        List<Object> textExtractors = new ArrayList();
        List<Object> authenticators = new ArrayList();
        block38: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKSPACES: {
                    this.parseWorkspaces(reader, address, repository);
                    continue block38;
                }
                case NODE_TYPES: {
                    this.parseNodeTypes(reader, repository);
                    continue block38;
                }
                case INDEXING: {
                    this.parseIndexing(reader, address, repository);
                    continue block38;
                }
                case RAM_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseRamIndexStorage(reader, repositoryName);
                    continue block38;
                }
                case LOCAL_FILE_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "local-file-index-storage");
                    continue block38;
                }
                case MASTER_FILE_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "master-file-index-storage");
                    continue block38;
                }
                case SLAVE_FILE_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseFileIndexStorage(reader, repositoryName, "slave-file-index-storage");
                    continue block38;
                }
                case CACHE_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseCacheIndexStorage(reader, repositoryName);
                    continue block38;
                }
                case CUSTOM_INDEX_STORAGE: {
                    this.addIndexStorageConfiguration(repositories, repositoryName);
                    indexStorage = this.parseCustomIndexStorage(reader, repositoryName);
                    continue block38;
                }
                case FILE_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseFileBinaryStorage(reader, repositoryName);
                    continue block38;
                }
                case DB_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseDatabaseBinaryStorage(reader, repositoryName);
                    continue block38;
                }
                case CACHE_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseCacheBinaryStorage(reader, repositoryName);
                    continue block38;
                }
                case CUSTOM_BINARY_STORAGE: {
                    this.addBinaryStorageConfiguration(repositories, repositoryName);
                    binaryStorage = this.parseCustomBinaryStorage(reader, repositoryName);
                    continue block38;
                }
                case AUTHENTICATORS: {
                    authenticators = this.parseAuthenticators(reader, repositoryName);
                    continue block38;
                }
                case SEQUENCERS: {
                    sequencers = this.parseSequencers(reader, address, repositoryName);
                    continue block38;
                }
                case EXTERNAL_SOURCES: {
                    externalSources = this.parseExternalSources(reader, address, repositoryName);
                    continue block38;
                }
                case TEXT_EXTRACTORS: {
                    textExtractors = this.parseTextExtracting(reader, repositoryName);
                    continue block38;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (indexStorage != null) {
            repositories.add(indexStorage);
        }
        if (binaryStorage != null) {
            repositories.add(binaryStorage);
        }
        repositories.addAll(sequencers);
        repositories.addAll(externalSources);
        repositories.addAll(textExtractors);
        repositories.addAll(authenticators);
    }

    private void parseNodeTypes(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NODE_TYPE: {
                    repository.get("node-types").add(reader.getElementText());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void addBinaryStorageConfiguration(List<ModelNode> repositories, String repositoryName) {
        ModelNode configuration = new ModelNode();
        configuration.get("operation").set("add");
        configuration.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage");
        repositories.add(configuration);
    }

    private void addIndexStorageConfiguration(List<ModelNode> repositories, String repositoryName) {
        ModelNode configuration = new ModelNode();
        configuration.get("operation").set("add");
        configuration.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "index-storage");
        repositories.add(configuration);
    }

    private void parseWorkspaces(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case ALLOW_WORKSPACE_CREATION: {
                        ModelAttributes.ALLOW_WORKSPACE_CREATION.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case DEFAULT_WORKSPACE: {
                        ModelAttributes.DEFAULT_WORKSPACE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.WORKSPACES_CACHE_CONTAINER.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKSPACE: {
                    this.parseWorkspace(reader, repository);
                    continue block10;
                }
                case INITIAL_CONTENT: {
                    repository.get("default-initial-content").set(reader.getElementText());
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseWorkspace(XMLExtendedStreamReader reader, ModelNode repository) throws XMLStreamException {
        String workspaceName = null;
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        workspaceName = attrValue;
                        repository.get("predefined-workspace-names").add(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INITIAL_CONTENT: {
                    if (workspaceName == null) continue block7;
                    repository.get("workspaces-initial-content").add(workspaceName, reader.getElementText());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode repository) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute element = Attribute.forName(attrName);
                switch (element) {
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case REBUILD_UPON_STARTUP_MODE: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP_MODE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case REBUILD_UPON_STARTUP_INCLUDE_SYSTEM_CONTENT: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP_INCLUDE_SYSTEM_CONTENT.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case SYSTEM_CONTENT_MODE: {
                        ModelAttributes.SYSTEM_CONTENT_MODE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, repository, (XMLStreamReader)reader);
                        continue block14;
                    }
                    default: {
                        if (attrName.startsWith("hibernate")) {
                            repository.get(attrName).set(attrValue);
                            continue block14;
                        }
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
    }

    private ModelNode parseRamIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "index-storage").add("storage-type", "ram-index-storage");
        if (reader.getAttributeCount() > 0) {
            block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute element = Attribute.forName(attrName);
                switch (element) {
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block10;
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseFileIndexStorage(XMLExtendedStreamReader reader, String repositoryName, String name) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "index-storage").add("storage-type", name);
        if (reader.getAttributeCount() > 0) {
            block22: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case PATH: {
                        ModelAttributes.PATH.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case ACCESS_TYPE: {
                        ModelAttributes.ACCESS_TYPE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case LOCKING_STRATEGY: {
                        ModelAttributes.LOCKING_STRATEGY.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case REFRESH_PERIOD: {
                        ModelAttributes.REFRESH_PERIOD.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case COPY_BUFFER_SIZE: {
                        ModelAttributes.COPY_BUFFER_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case SOURCE_PATH: {
                        ModelAttributes.SOURCE_PATH.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case SOURCE_RELATIVE_TO: {
                        ModelAttributes.SOURCE_RELATIVE_TO.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case CONNECTION_FACTORY_JNDI_NAME: {
                        ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    case QUEUE_JNDI_NAME: {
                        ModelAttributes.QUEUE_JNDI_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block22;
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseCacheIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "index-storage").add("storage-type", "cache-index-storage");
        if (reader.getAttributeCount() > 0) {
            block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case LOCK_CACHE_NAME: {
                        ModelAttributes.LOCK_CACHE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case DATA_CACHE_NAME: {
                        ModelAttributes.DATA_CACHE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case META_CACHE_NAME: {
                        ModelAttributes.METADATA_CACHE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.CACHE_CONTAINER.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case CHUNK_SIZE: {
                        ModelAttributes.CHUNK_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block8;
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseCustomIndexStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "index-storage").add("storage-type", "custom-index-storage");
        if (reader.getAttributeCount() > 0) {
            block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case FORMAT: {
                        ModelAttributes.INDEX_FORMAT.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case REBUILD_UPON_STARTUP: {
                        ModelAttributes.REBUILD_INDEXES_UPON_STARTUP.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case THREAD_POOL: {
                        ModelAttributes.THREAD_POOL.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case BATCH_SIZE: {
                        ModelAttributes.BATCH_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case READER_STRATEGY: {
                        ModelAttributes.READER_STRATEGY.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case MODE: {
                        ModelAttributes.MODE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_THREAD_POOL_SIZE: {
                        ModelAttributes.ASYNC_THREAD_POOL_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ASYNC_MAX_QUEUE_SIZE: {
                        ModelAttributes.ASYNC_MAX_QUEUE_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_CLASSNAME: {
                        ModelAttributes.ANALYZER_CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case ANALYZER_MODULE: {
                        ModelAttributes.ANALYZER_MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block14;
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseFileBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage").add("storage-type", "file-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case RELATIVE_TO: {
                        ModelAttributes.RELATIVE_TO.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case PATH: {
                        ModelAttributes.PATH.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseCacheBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage").add("storage-type", "cache-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case DATA_CACHE_NAME: {
                        ModelAttributes.DATA_CACHE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case META_CACHE_NAME: {
                        ModelAttributes.METADATA_CACHE_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case CACHE_CONTAINER: {
                        ModelAttributes.CACHE_CONTAINER.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseDatabaseBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage").add("storage-type", "db-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case DATA_SOURCE_JNDI_NAME: {
                        ModelAttributes.DATA_SOURCE_JNDI_NAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private ModelNode parseCustomBinaryStorage(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ModelNode storageType = new ModelNode();
        storageType.get("operation").set("add");
        storageType.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("configuration", "binary-storage").add("storage-type", "custom-binary-storage");
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case CLASSNAME: {
                        ModelAttributes.CLASSNAME.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_VALUE_SIZE: {
                        ModelAttributes.MINIMUM_BINARY_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case MIN_STRING_SIZE: {
                        ModelAttributes.MINIMUM_STRING_SIZE.parseAndSetParameter(attrValue, storageType, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        storageType.get(attrName).set(attrValue);
                    }
                }
            }
        }
        this.requireNoElements(reader);
        return storageType;
    }

    private List<ModelNode> parseAuthenticators(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> authenticators = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATOR: {
                    this.parseAuthenticator(reader, repositoryName, authenticators);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return authenticators;
    }

    private void parseAuthenticator(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> authenticators) throws XMLStreamException {
        ModelNode authenticator = new ModelNode();
        authenticator.get("operation").set("add");
        String name = null;
        authenticators.add(authenticator);
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case CLASSNAME: {
                        ModelAttributes.AUTHENTICATOR_CLASSNAME.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        if (name != null) continue block5;
                        name = attrValue;
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, authenticator, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        authenticator.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        authenticator.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("authenticator", name);
        this.requireNoElements(reader);
    }

    private List<ModelNode> parseSequencers(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> sequencers = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SEQUENCER: {
                    this.parseSequencer(reader, repositoryName, sequencers);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return sequencers;
    }

    private void parseSequencer(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> sequencers) throws XMLStreamException {
        ModelNode sequencer = new ModelNode();
        sequencer.get("operation").set("add");
        String name = null;
        sequencers.add(sequencer);
        if (reader.getAttributeCount() > 0) {
            block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block9;
                    }
                    case PATH_EXPRESSION: {
                        ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    case CLASSNAME: {
                        ModelAttributes.SEQUENCER_CLASSNAME.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        if (name != null) continue block9;
                        name = attrValue;
                        continue block9;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, sequencer, (XMLStreamReader)reader);
                        continue block9;
                    }
                    default: {
                        sequencer.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATH_EXPRESSION: {
                    String value = reader.getElementText();
                    ModelAttributes.PATH_EXPRESSIONS.parseAndAddParameterElement(value, sequencer, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        sequencer.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("sequencer", name);
    }

    private List<ModelNode> parseExternalSources(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> externalSources = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOURCE: {
                    this.parseExternalSource(reader, repositoryName, externalSources);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return externalSources;
    }

    private void parseExternalSource(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> externalSources) throws XMLStreamException {
        ModelNode externalSource = new ModelNode();
        externalSource.get("operation").set("add");
        String name = null;
        externalSources.add(externalSource);
        if (reader.getAttributeCount() > 0) {
            block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case CLASSNAME: {
                        ModelAttributes.CONNECTOR_CLASSNAME.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        if (name != null) continue block11;
                        name = attrValue;
                        continue block11;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case CACHE_TTL_SECONDS: {
                        ModelAttributes.CACHE_TTL_SECONDS.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case QUERYABLE: {
                        ModelAttributes.QUERYABLE.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case READONLY: {
                        ModelAttributes.READONLY.parseAndSetParameter(attrValue, externalSource, (XMLStreamReader)reader);
                        continue block11;
                    }
                    default: {
                        externalSource.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROJECTION: {
                    String value = reader.getElementText();
                    ModelAttributes.PROJECTIONS.parseAndAddParameterElement(value, externalSource, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        externalSource.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("source", name);
    }

    private List<ModelNode> parseTextExtracting(XMLExtendedStreamReader reader, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> extractors = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TEXT_EXTRACTOR: {
                    this.parseTextExtractor(reader, repositoryName, extractors);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return extractors;
    }

    private void parseTextExtractor(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> extractors) throws XMLStreamException {
        ModelNode extractor = new ModelNode();
        extractor.get("operation").set("add");
        String name = null;
        extractors.add(extractor);
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case CLASSNAME: {
                        ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.parseAndSetParameter(attrValue, extractor, (XMLStreamReader)reader);
                        if (name != null) continue block5;
                        name = attrValue;
                        continue block5;
                    }
                    case MODULE: {
                        ModelAttributes.MODULE.parseAndSetParameter(attrValue, extractor, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        extractor.get("properties").add(attrName, attrValue);
                    }
                }
            }
        }
        extractor.get("address").add("subsystem", "modeshape").add("repository", repositoryName).add("text-extractor", name);
        this.requireNoElements(reader);
    }

    protected void requireNoElements(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

