/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.List;
import java.util.Properties;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;

public class SourceService
implements Service<JcrRepository> {
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private final Properties sourceProperties;
    private final String repositoryName;

    public SourceService(String repositoryName, Properties sourceProperties) {
        this.repositoryName = repositoryName;
        this.sourceProperties = sourceProperties;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return (JcrRepository)this.jcrRepositoryInjector.getValue();
    }

    private ModeShapeEngine getModeShapeEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getModeShapeEngine();
        JcrRepository repository = null;
        try {
            repository = engine.getRepository(this.repositoryName);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        RepositoryConfiguration repositoryConfig = repository.getConfiguration();
        Editor configEditor = repositoryConfig.edit();
        EditableDocument externalSources = configEditor.getOrCreateDocument("externalSources");
        EditableDocument externalSource = Schematic.newDocument();
        for (Object key : this.sourceProperties.keySet()) {
            String keyStr = (String)key;
            if ("name".equals(keyStr)) continue;
            Object value = this.sourceProperties.get(keyStr);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    externalSource.getOrCreateArray(keyStr).addValue(val);
                }
                continue;
            }
            externalSource.set(keyStr, value);
        }
        String sourceName = this.sourceProperties.getProperty("name");
        assert (sourceName != null);
        externalSources.setDocument(sourceName, (Document)externalSource);
        try {
            engine.update(this.repositoryName, configEditor.getChanges());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext arg0) {
    }

    public InjectedValue<ModeShapeEngine> getModeShapeEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }
}

