/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.modeshape.jboss.subsystem.ModelAttributes;

class AddWebApp
extends AbstractAddStepHandler {
    private static final Logger LOGGER = Logger.getLogger((String)AddWebApp.class.getPackage().getName());
    static final AddWebApp INSTANCE = new AddWebApp();

    AddWebApp() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        resource.getModel().setEmptyObject();
        if (this.requiresRuntime(context)) {
            ModelNode address = operation.require("address");
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
            String webappName = pathAddress.getLastElement().getValue();
            boolean exploded = this.attribute(context, resource.getModel(), (AttributeDefinition)ModelAttributes.EXPLODED).asBoolean();
            PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)webappName)});
            ModelNode op = Util.createOperation((String)"add", (PathAddress)deploymentAddress);
            op.get("enabled").set(true);
            op.get("persistent").set(false);
            Module module = Module.forClass(((Object)((Object)this)).getClass());
            URL url = module.getExportedResource(webappName);
            if (url == null) {
                LOGGER.error((Object)("Cannot deploy ModeShape webapp: " + webappName + " because it cannot be located by the main modeshape module"));
                return;
            }
            ModelNode contentItem = new ModelNode();
            if (exploded) {
                String urlString = null;
                try {
                    urlString = new File(url.toURI()).getAbsolutePath();
                }
                catch (URISyntaxException e) {
                    throw new OperationFailedException(e.getMessage(), (Throwable)e);
                }
                contentItem.get("path").set(urlString);
                contentItem.get("archive").set(false);
            } else {
                contentItem.get("url").set(url.toExternalForm());
            }
            op.get("content").add(contentItem);
            ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
            OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
            context.addStep(op, handler, OperationContext.Stage.MODEL);
        }
    }

    private ModelNode attribute(OperationContext context, ModelNode model, AttributeDefinition defn) throws OperationFailedException {
        assert (defn.getDefaultValue() != null && defn.getDefaultValue().isDefined());
        return defn.resolveModelAttribute(context, model);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        throw new UnsupportedOperationException();
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

