/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.DelegatingClassLoader;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.IndexStorage;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryStatistics;

public class RepositoryService
implements Service<JcrRepository>,
Environment {
    public static final String CONTENT_CONTAINER_NAME = "content";
    public static final String BINARY_STORAGE_CONTAINER_NAME = "binaries";
    public static final String WORKSPACES_CONTAINER_NAME = "workspaces";
    private static final Logger LOG = Logger.getLogger((String)RepositoryService.class.getPackage().getName());
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<CacheContainer> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<CacheContainer> workspacesCacheContainerInjector = new InjectedValue();
    private final InjectedValue<ChannelFactory> channelFactoryInjector = new InjectedValue();
    private final InjectedValue<IndexStorage> indexStorageConfigInjector = new InjectedValue();
    private final InjectedValue<BinaryStorage> binaryStorageInjector = new InjectedValue();
    private final InjectedValue<String> dataDirectoryPathInjector = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoaderInjector = new InjectedValue();
    private final InjectedValue<RepositoryStatistics> monitorInjector = new InjectedValue();
    private RepositoryConfiguration repositoryConfiguration;

    public RepositoryService(RepositoryConfiguration repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        try {
            return this.getEngine().getRepository(this.repositoryName());
        }
        catch (NoSuchRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private ModeShapeEngine getEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public CacheContainer getCacheContainer(String name) {
        CacheContainer container = null;
        if (BINARY_STORAGE_CONTAINER_NAME.equals(name)) {
            BinaryStorage storage = (BinaryStorage)this.binaryStorageInjector.getValue();
            container = storage.getCacheContainer();
        }
        if (WORKSPACES_CONTAINER_NAME.equals(name)) {
            container = (CacheContainer)this.workspacesCacheContainerInjector.getValue();
        }
        if (container == null) {
            container = (CacheContainer)this.cacheManagerInjector.getValue();
        }
        return container;
    }

    public Channel getChannel(String name) throws Exception {
        return ((ChannelFactory)this.channelFactoryInjector.getValue()).createChannel(name);
    }

    public ClassLoader getClassLoader(ClassLoader fallbackLoader, String ... classpathEntries) {
        ArrayList<Object> delegatingLoaders = new ArrayList<Object>();
        if (classpathEntries != null) {
            for (String moduleIdString : classpathEntries) {
                if (StringUtil.isBlank((String)moduleIdString)) continue;
                try {
                    ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString((String)moduleIdString);
                    delegatingLoaders.add(this.moduleLoader().loadModule(moduleIdentifier).getClassLoader());
                }
                catch (IllegalArgumentException e) {
                    LOG.warnv("The string (classpath entry) is not a valid module identifier: {0}", (Object)moduleIdString);
                }
                catch (ModuleLoadException e) {
                    LOG.warnv("Cannot load module from (from classpath entry) with identifier: {0}", (Object)moduleIdString);
                }
            }
        }
        ClassLoader currentLoader = this.getClass().getClassLoader();
        if (fallbackLoader != null && !fallbackLoader.equals(currentLoader)) {
            if (fallbackLoader.getParent().equals(currentLoader)) {
                currentLoader = fallbackLoader;
            } else {
                delegatingLoaders.add(fallbackLoader);
            }
        }
        return delegatingLoaders.isEmpty() ? currentLoader : new DelegatingClassLoader(currentLoader, delegatingLoaders);
    }

    public void shutdown() {
    }

    public final String repositoryName() {
        return this.repositoryConfiguration.getName();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getEngine();
        try {
            String repositoryName = this.repositoryName();
            IndexStorage indexStorageConfig = (IndexStorage)this.indexStorageConfigInjector.getValue();
            assert (indexStorageConfig != null);
            if (indexStorageConfig.isEnabled()) {
                CacheContainer repositoryCacheContainer;
                CacheContainer indexStorageCacheContainer = indexStorageConfig.getCacheContainer();
                if (indexStorageCacheContainer != null && indexStorageCacheContainer == (repositoryCacheContainer = this.getCacheContainer(null))) {
                    throw new StartException("The repository cache container and the index storage cannot container cannot be the same");
                }
            } else {
                LOG.warnv("Queries are disabled for the {0} repository", (Object)repositoryName);
            }
            EditableDocument queryConfig = indexStorageConfig.getQueryConfiguration();
            assert (queryConfig != null);
            BinaryStorage binaryStorageConfig = (BinaryStorage)this.binaryStorageInjector.getValue();
            assert (binaryStorageConfig != null);
            EditableDocument binaryConfig = binaryStorageConfig.getBinaryConfiguration();
            assert (binaryConfig != null);
            EditableDocument config = Schematic.newDocument((Document)this.repositoryConfiguration.getDocument());
            config.setDocument("query", (Document)queryConfig);
            config.getOrCreateDocument("storage").setDocument("binaryStorage", (Document)binaryConfig);
            if (LOG.isDebugEnabled()) {
                LOG.debugv("ModeShape configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)config);
                Problems problems = this.repositoryConfiguration.validate();
                if (problems.isEmpty()) {
                    LOG.debugv("Problems with configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)problems);
                }
            }
            this.repositoryConfiguration = new RepositoryConfiguration((Document)config, repositoryName);
            engine.deploy(this.repositoryConfiguration.with((Environment)this));
        }
        catch (ConfigurationException e) {
            throw new StartException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ModeShapeEngine engine = this.getEngine();
        if (engine != null) {
            try {
                engine.undeploy(this.repositoryName());
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {
                // empty catch block
            }
        }
    }

    public void changeField(MappedAttributeDefinition defn, ModelNode newValue) throws RepositoryException, OperationFailedException {
        String fieldName2;
        Editor editor;
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor fieldContainer = editor = config.edit();
        for (String fieldName2 : defn.getPathToContainerOfField()) {
            fieldContainer = editor.getOrCreateDocument(fieldName2);
        }
        Object rawValue = defn.getTypedValue(newValue);
        fieldName2 = defn.getFieldName();
        fieldContainer.set(fieldName2, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSequencerField(MappedAttributeDefinition defn, ModelNode newValue, String sequencerName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument sequencing = editor.getOrCreateDocument(pathToContainer.get(0));
        EditableArray sequencers = sequencing.getOrCreateArray(pathToContainer.get(1));
        for (String configuredSequencerName : sequencers.keySet()) {
            if (!sequencerName.equals(configuredSequencerName)) continue;
            EditableDocument sequencer = (EditableDocument)sequencers.get(configuredSequencerName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            sequencer.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSourceField(MappedAttributeDefinition defn, ModelNode newValue, String sourceName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument externalSources = editor.getOrCreateDocument("externalSources");
        EditableDocument externalSource = externalSources.getDocument(sourceName);
        assert (externalSource != null);
        String fieldName = defn.getFieldName();
        Object rawValue = defn.getTypedValue(newValue);
        externalSource.set(fieldName, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeTextExtractorField(MappedAttributeDefinition defn, ModelNode newValue, String extractorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument textExtracting = editor.getOrCreateDocument(pathToContainer.get(1));
        EditableDocument extractors = textExtracting.getOrCreateDocument(pathToContainer.get(2));
        for (String configuredExtractorName : extractors.keySet()) {
            if (!extractorName.equals(configuredExtractorName)) continue;
            EditableDocument extractor = (EditableDocument)extractors.get(configuredExtractorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            extractor.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeAuthenticatorField(MappedAttributeDefinition defn, ModelNode newValue, String authenticatorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument security = editor.getOrCreateDocument("security");
        EditableArray providers = security.getOrCreateArray("providers");
        for (String configuredAuthenticatorName : providers.keySet()) {
            if (!authenticatorName.equals(configuredAuthenticatorName)) continue;
            boolean found = false;
            for (Object nested : providers) {
                EditableDocument doc;
                if (!(nested instanceof EditableDocument) || !(doc = (EditableDocument)nested).getString("name").equals(configuredAuthenticatorName)) continue;
                String fieldName = defn.getFieldName();
                Object rawValue = defn.getTypedValue(newValue);
                doc.set(fieldName, rawValue);
                found = true;
                break;
            }
            if (found) break;
            EditableDocument doc = Schematic.newDocument();
            doc.set("name", (Object)configuredAuthenticatorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            doc.set(fieldName, rawValue);
            providers.add((Object)doc);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public InjectedValue<IndexStorage> getIndexStorageConfigInjector() {
        return this.indexStorageConfigInjector;
    }

    public InjectedValue<BinaryStorage> getBinaryStorageInjector() {
        return this.binaryStorageInjector;
    }

    public InjectedValue<RepositoryStatistics> getMonitorInjector() {
        return this.monitorInjector;
    }

    public InjectedValue<ModeShapeEngine> getEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<CacheContainer> getCacheManagerInjector() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<ChannelFactory> getChannelFactoryInjector() {
        return this.channelFactoryInjector;
    }

    public InjectedValue<String> getDataDirectoryPathInjector() {
        return this.dataDirectoryPathInjector;
    }

    public InjectedValue<ModuleLoader> getModuleLoaderInjector() {
        return this.moduleLoaderInjector;
    }

    public InjectedValue<CacheContainer> getWorkspacesCacheContainerInjector() {
        return this.workspacesCacheContainerInjector;
    }

    private ModuleLoader moduleLoader() {
        return (ModuleLoader)this.moduleLoaderInjector.getValue();
    }
}

