/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AbstractModeShapeRemoveStepHandler;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

class RemoveCompositeBinaryStorage
extends AbstractModeShapeRemoveStepHandler {
    static final RemoveCompositeBinaryStorage INSTANCE = new RemoveCompositeBinaryStorage();

    private RemoveCompositeBinaryStorage() {
    }

    @Override
    List<ServiceName> servicesToRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = this.repositoryName(operation);
        ArrayList<ServiceName> servicesToRemove = new ArrayList<ServiceName>();
        List nestedStores = model.get("nested-stores").asList();
        for (ModelNode nestedStore : nestedStores) {
            String nestedStoreName = nestedStore.asString();
            ServiceName nestedServiceName = ModeShapeServiceNames.binaryStorageNestedServiceName(repositoryName, nestedStoreName);
            servicesToRemove.add(nestedServiceName);
        }
        if (model.has("nested-storage-type-file")) {
            List storageNodes = model.get("nested-storage-type-file").asList();
            for (ModelNode storageNode : storageNodes) {
                String storeName;
                ModelNode storageContent = storageNode.get(storeName = (String)storageNode.keys().toArray()[0]);
                String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, storageContent).asString();
                if (!relativeTo.equalsIgnoreCase("jboss.server.data.dir")) continue;
                ServiceName dirServiceName = ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName, storeName);
                servicesToRemove.add(dirServiceName);
            }
        }
        servicesToRemove.add(ModeShapeServiceNames.binaryStorageDefaultServiceName(repositoryName));
        return servicesToRemove;
    }
}

