/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

public abstract class AbstractAddBinaryStorage
extends AbstractAddStepHandler {
    protected AbstractAddBinaryStorage() {
    }

    static void populate(ModelNode operation, ModelNode model, AttributeDefinition[] attributes) throws OperationFailedException {
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        EditableDocument binaries = Schematic.newDocument();
        this.writeCommonBinaryStorageConfiguration(context, model, binaries);
        this.writeBinaryStorageConfiguration(repositoryName, context, model, binaries);
        boolean isNestedStore = model.hasDefined("store-name");
        ServiceName serviceName = ModeShapeServiceNames.binaryStorageDefaultServiceName(repositoryName);
        if (isNestedStore) {
            String binaryStorageName = binaries.getString("storeName");
            assert (binaryStorageName != null);
            serviceName = ModeShapeServiceNames.binaryStorageNestedServiceName(repositoryName, binaryStorageName);
        } else {
            context.removeService(serviceName);
        }
        this.createBinaryStorageService(context, model, newControllers, target, repositoryName, binaries, serviceName);
    }

    protected void createBinaryStorageService(OperationContext context, ModelNode model, List<ServiceController<?>> newControllers, ServiceTarget target, String repositoryName, EditableDocument binaries, ServiceName serviceName) throws OperationFailedException {
        BinaryStorageService service = new BinaryStorageService(repositoryName, binaries);
        ServiceBuilder builder = target.addService(serviceName, (Service)service);
        String binariesStoreName = binaries.containsField("storeName") ? binaries.getString("storeName") : null;
        this.addControllersAndDependencies(repositoryName, service, (ServiceBuilder<BinaryStorage>)builder, newControllers, target, binariesStoreName);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(builder.install());
    }

    protected abstract void writeBinaryStorageConfiguration(String var1, OperationContext var2, ModelNode var3, EditableDocument var4) throws OperationFailedException;

    protected void writeCommonBinaryStorageConfiguration(OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        ModelNode storeName;
        ModelNode stringSize;
        ModelNode minBinarySize = ModelAttributes.MINIMUM_BINARY_SIZE.resolveModelAttribute(context, model);
        if (minBinarySize.isDefined()) {
            binaries.set("minimumBinarySizeInBytes", (Object)minBinarySize.asInt());
        }
        if ((stringSize = ModelAttributes.MINIMUM_STRING_SIZE.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("minimumStringSize", (Object)stringSize.asInt());
        }
        if ((storeName = ModelAttributes.STORE_NAME.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("storeName", (Object)storeName.asString());
        }
    }

    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, List<ServiceController<?>> newControllers, ServiceTarget target, String binariesStoreName) throws OperationFailedException {
    }
}

