/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.IndexStorage;
import org.modeshape.jboss.service.IndexStorageService;
import org.modeshape.jboss.subsystem.AbstractAddIndexStorage;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

public abstract class AbstractAddFileSystemIndexStorage
extends AbstractAddIndexStorage {
    protected String indexStoragePathInDataDirectory;
    protected String indexSourcePathInDataDirectory;

    protected AbstractAddFileSystemIndexStorage() {
    }

    protected void setIndexStoragePathInDataDirectory(String relativePath) {
        this.indexStoragePathInDataDirectory = relativePath;
    }

    protected void setIndexSourcePathInDataDirectory(String relativePath) {
        this.indexSourcePathInDataDirectory = relativePath;
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, IndexStorageService service, List<ServiceController<?>> newControllers, ServiceBuilder<IndexStorage> builder, ServiceTarget target) {
        ServiceName serviceName;
        if (this.indexStoragePathInDataDirectory != null) {
            serviceName = ModeShapeServiceNames.indexStorageDirectoryServiceName(repositoryName);
            newControllers.add(RelativePathService.addService((ServiceName)serviceName, (String)this.indexStoragePathInDataDirectory, (String)"jboss.server.data.dir", (ServiceTarget)target));
            builder.addDependency(serviceName, String.class, service.getIndexStorageBasePathInjector());
        }
        if (this.indexSourcePathInDataDirectory != null) {
            serviceName = ModeShapeServiceNames.indexSourceStorageDirectoryServiceName(repositoryName);
            newControllers.add(RelativePathService.addService((ServiceName)serviceName, (String)this.indexSourcePathInDataDirectory, (String)"jboss.server.data.dir", (ServiceTarget)target));
            builder.addDependency(serviceName, String.class, service.getIndexStorageSourceBasePathInjector());
        }
    }

    protected void processLocalIndexStorageLocation(OperationContext context, ModelNode modelNode, String repositoryName, EditableDocument indexStorage) throws OperationFailedException {
        ModelNode pathNode = ModelAttributes.PATH.resolveModelAttribute(context, modelNode);
        String path = pathNode.isDefined() ? pathNode.asString() : "modeshape/" + repositoryName + "/indexes";
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, modelNode).asString();
        if (relativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            this.setIndexStoragePathInDataDirectory(".");
            indexStorage.set("location", (Object)path);
        } else {
            if (!relativeTo.endsWith("/")) {
                relativeTo = relativeTo + "/";
            }
            indexStorage.set("location", (Object)(relativeTo + path));
        }
    }

    protected void processSourceIndexStorageLocation(OperationContext context, ModelNode modelNode, String repositoryName, EditableDocument indexStorage) throws OperationFailedException {
        ModelNode sourcePathNode = ModelAttributes.SOURCE_PATH.resolveModelAttribute(context, modelNode);
        String sourcePath = sourcePathNode.isDefined() ? sourcePathNode.asString() : "modeshape/" + repositoryName + "/indexes_master";
        String sourceRelativeTo = ModelAttributes.SOURCE_RELATIVE_TO.resolveModelAttribute(context, modelNode).asString();
        if (sourceRelativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            this.setIndexSourcePathInDataDirectory(".");
            indexStorage.set("sourceLocation", (Object)sourcePath);
        } else {
            if (!sourceRelativeTo.endsWith("/")) {
                sourceRelativeTo = sourceRelativeTo + "/";
            }
            indexStorage.set("sourceLocation", (Object)(sourceRelativeTo + sourcePath));
        }
    }
}

