/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.SourceService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;

public class AddSource
extends AbstractAddStepHandler {
    static final AddSource INSTANCE = new AddSource();
    private static final Logger LOGGER = Logger.getLogger((String)AddSource.class.getPackage().getName());
    private static final List<String> LIST_PROPERTIES = Arrays.asList("queryableBranches");

    private AddSource() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddSource.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.SOURCE_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        String sourceName = pathAddress.getLastElement().getValue();
        Properties props = new Properties();
        props.put("name", sourceName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("classname") && ModelAttributes.CONNECTOR_CLASSNAME.isMarshallable(operation)) {
                props.put("classname", node.asString());
                continue;
            }
            if (key.equals("module") && ModelAttributes.MODULE.isMarshallable(operation)) {
                props.put("classloader", node.asString());
                continue;
            }
            if (key.equals("projections")) {
                ArrayList<String> projections = new ArrayList<String>();
                for (ModelNode projection : operation.get("projections").asList()) {
                    projections.add(projection.asString());
                }
                props.put("projections", projections);
                continue;
            }
            if (key.equals("properties")) {
                for (Property property : node.asPropertyList()) {
                    props.put(property.getName(), this.propertyValue(property));
                }
                continue;
            }
            if (key.equalsIgnoreCase("cacheTtlSeconds")) {
                props.put(key, (Object)node.asInt());
                continue;
            }
            if (key.equalsIgnoreCase("queryable") || key.equalsIgnoreCase("readonly")) {
                props.put(key, (Object)node.asBoolean());
                continue;
            }
            props.put(key, node.asString());
        }
        this.ensureClassLoadingPropertyIsSet(props);
        SourceService sourceService = new SourceService(repositoryName, props);
        ServiceBuilder sourceServiceBuilder = target.addService(ModeShapeServiceNames.sourceServiceName(repositoryName, sourceName), (Service)sourceService);
        sourceServiceBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, sourceService.getModeShapeEngineInjector());
        sourceServiceBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, sourceService.getJcrRepositoryInjector());
        sourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = sourceServiceBuilder.install();
        newControllers.add(controller);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    private Object propertyValue(Property property) {
        String propertyName = property.getName();
        String valueAsString = property.getValue().asString();
        if (!LIST_PROPERTIES.contains(propertyName)) {
            return valueAsString;
        }
        String[] values = valueAsString.split(",");
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String value : values) {
            result.add(value.trim());
        }
        return result;
    }

    private void ensureClassLoadingPropertyIsSet(Properties sourceProperties) {
        if (sourceProperties.containsKey("classloader")) {
            return;
        }
        String connectorClassName = sourceProperties.getProperty("classname");
        if (StringUtil.isBlank((String)connectorClassName)) {
            LOGGER.warnv("Required property: {0} not found among the source properties: {1}", (Object)"classname", (Object)sourceProperties);
            return;
        }
        int index = connectorClassName.lastIndexOf(".");
        String connectorModuleName = index != -1 ? connectorClassName.substring(0, index) : connectorClassName;
        sourceProperties.setProperty("classloader", connectorModuleName);
    }
}

