/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.TextExtractorService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

public class AddTextExtractor
extends AbstractAddStepHandler {
    public static final AddTextExtractor INSTANCE = new AddTextExtractor();
    private static final Logger LOG = Logger.getLogger((String)AddTextExtractor.class.getPackage().getName());

    private AddTextExtractor() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddTextExtractor.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.TEXT_EXTRACTOR_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        String extractorName = pathAddress.getLastElement().getValue();
        props.put("name", extractorName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("classname") && ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.isMarshallable(operation)) {
                props.put("classname", node.asString());
                continue;
            }
            if (key.equals("module") && ModelAttributes.MODULE.isMarshallable(operation)) {
                props.put("classloader", node.asString());
                continue;
            }
            if (key.equals("properties")) {
                for (Property property : node.asPropertyList()) {
                    props.put(property.getName(), property.getValue().asString());
                }
                continue;
            }
            props.put(key, node.asString());
        }
        this.ensureClassLoadingPropertyIsSet(props);
        TextExtractorService extractorService = new TextExtractorService(repositoryName, props);
        ServiceName serviceName = ModeShapeServiceNames.textExtractorServiceName(repositoryName, extractorName);
        ServiceBuilder extractorBuilder = target.addService(serviceName, (Service)extractorService);
        extractorBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, extractorService.getModeShapeEngineInjector());
        extractorBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, extractorService.getJcrRepositoryInjector());
        extractorBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = extractorBuilder.install();
        newControllers.add(controller);
    }

    protected boolean requiresRuntimeVerification() {
        return true;
    }

    private void ensureClassLoadingPropertyIsSet(Properties properties) {
        int index;
        if (properties.containsKey("classloader")) {
            return;
        }
        String textExtractorClassName = properties.getProperty("classname");
        if (StringUtil.isBlank((String)textExtractorClassName)) {
            LOG.warnv("Required property: {0} not found among the text extractor properties: {1}", (Object)"classname", (Object)properties);
            return;
        }
        String fqExtractorClass = RepositoryConfiguration.getBuiltInTextExtractorClassName((String)textExtractorClassName);
        if (fqExtractorClass == null) {
            fqExtractorClass = textExtractorClassName;
        }
        String extractorModuleName = (index = fqExtractorClass.lastIndexOf(".")) != -1 ? fqExtractorClass.substring(0, index) : fqExtractorClass;
        properties.setProperty("classloader", extractorModuleName);
    }
}

