/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jboss.subsystem.ModeShapeExtension;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModeShapeConfigurationTest
extends AbstractSubsystemBaseTest {
    private static final AdditionalInitialization NORMAL_INITIALIZATION_MODE = new AdditionalInitialization();

    public ModeShapeConfigurationTest() {
        super("modeshape", (Extension)new ModeShapeExtension());
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource("modeshape-sample-config.xml");
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return NORMAL_INITIALIZATION_MODE;
    }

    protected String getSubsystemXml(String configId) throws IOException {
        return configId != null ? this.readResource("modeshape-" + configId + "-config.xml") : this.getSubsystemXml();
    }

    @Test
    public void testMinimalConfiguration() throws Exception {
        this.standardSubsystemTest("minimal");
    }

    @Test
    public void testFullConfiguration() throws Exception {
        this.standardSubsystemTest("full");
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithLocalFileIndexStorage() throws Exception {
        this.parse(this.readResource("modeshape-local-file-index-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithFileBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-file-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCacheBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-cache-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCompositeBinaryStores() throws Exception {
        this.parse(this.readResource("modeshape-composite-binary-storage-config.xml"));
    }

    @Test(expected=XMLStreamException.class)
    public void shouldRejectInvalidCompositeBinaryStoreConfiguration() throws Exception {
        this.parse(this.readResource("modeshape-invalid-composite-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWorkspaceInitialContent() throws Exception {
        this.parse(this.readResource("modeshape-initial-content-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithNodeTypes() throws Exception {
        this.parse(this.readResource("modeshape-node-types-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCustomAuthenticators() throws Exception {
        this.parse(this.readResource("modeshape-custom-authenticators-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWorkspacesCacheContainer() throws Exception {
        this.parse(this.readResource("modeshape-workspaces-cache-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithExternalSources() throws Exception {
        this.parse(this.readResource("modeshape-federation-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithGarbageCollectionSpecified() throws Exception {
        this.parse(this.readResource("modeshape-garbage-collection.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWebapps() throws Exception {
        this.parse(this.readResource("modeshape-webapp-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithJournaling() throws Exception {
        this.parse(this.readResource("modeshape-journaling.xml"));
    }

    @Test
    public void testSampleConfigurationModel() throws Exception {
        List nodes = this.parse(this.readResource("modeshape-sample-config.xml"));
        Assert.assertEquals((long)7L, (long)nodes.size());
        ModelNode subsystem = (ModelNode)nodes.get(0);
        this.assertNode(subsystem.get("address"), new KeyValue("subsystem", "modeshape"));
        ModelNode repo1 = (ModelNode)nodes.get(1);
        this.assertNode(repo1.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample1"));
        Assert.assertEquals((Object)repo1.get("jndi-name").asString(), (Object)"jcr/local/modeshape_repo1");
        ModelNode seq1 = (ModelNode)nodes.get(2);
        this.assertNode(seq1.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample1"), new KeyValue("sequencer", "modeshape-sequencer-ddl"));
        Assert.assertEquals((Object)seq1.get("classname").asString(), (Object)"ddl");
        Assert.assertEquals((Object)((ModelNode)seq1.get("path-expressions").asList().get(0)).asString(), (Object)"//a/b");
        ModelNode seq2 = (ModelNode)nodes.get(3);
        this.assertNode(seq2.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample1"), new KeyValue("sequencer", "modeshape-sequencer-java"));
        Assert.assertEquals((Object)seq2.get("classname").asString(), (Object)"java");
        Assert.assertEquals((Object)((ModelNode)seq2.get("path-expressions").asList().get(0)).asString(), (Object)"//a/b");
        this.assertNode(seq2.get("properties"), new KeyValue("extra1", "value1"), new KeyValue("extra2", "2"));
        ModelNode repo2 = (ModelNode)nodes.get(4);
        this.assertNode(repo2.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample2"));
        ModelNode seq3 = (ModelNode)nodes.get(5);
        this.assertNode(seq3.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample2"), new KeyValue("sequencer", "modeshape-sequencer-ddl"));
        Assert.assertEquals((Object)seq3.get("classname").asString(), (Object)"ddl");
        Assert.assertEquals((Object)((ModelNode)seq3.get("path-expressions").asList().get(0)).asString(), (Object)"//a/b/");
        Assert.assertEquals((Object)((ModelNode)seq3.get("path-expressions").asList().get(1)).asString(), (Object)"//a/b2/");
        ModelNode seq4 = (ModelNode)nodes.get(6);
        this.assertNode(seq4.get("address"), new KeyValue("subsystem", "modeshape"), new KeyValue("repository", "sample2"), new KeyValue("sequencer", "modeshape-sequencer-java"));
        Assert.assertEquals((Object)seq4.get("classname").asString(), (Object)"java");
        Assert.assertEquals((Object)((ModelNode)seq4.get("path-expressions").asList().get(0)).asString(), (Object)"//a/b");
    }

    @Test
    public void testAddRemoveRepository() throws Exception {
        String subsystemXml = this.readResource("modeshape-sample-config.xml");
        this.validate(subsystemXml);
        KernelServices services = this.initKernel(subsystemXml);
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")});
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("repository");
        ModelNode result = services.executeOperation(read, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        List<String> opNames = ModeShapeConfigurationTest.getList(result);
        Assert.assertEquals((long)2L, (long)opNames.size());
        String[] ops = new String[]{"sample1", "sample2"};
        Assert.assertEquals(Arrays.asList(ops), opNames);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("repository", "myrepository"));
        addOp.get("jndi-name").set("jcr:local:myrepository");
        result = services.executeOperation(addOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(read, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        opNames = ModeShapeConfigurationTest.getList(result);
        Assert.assertEquals((long)3L, (long)opNames.size());
        String[] ops2 = new String[]{"myrepository", "sample1", "sample2"};
        Assert.assertEquals(Arrays.asList(ops2), opNames);
    }

    private KernelServices initKernel(String subsystemXml) throws Exception {
        return super.createKernelServicesBuilder(NORMAL_INITIALIZATION_MODE).setSubsystemXml(subsystemXml).build();
    }

    @Test
    public void testAnonymousRolesConfiguration() throws Exception {
        this.standardSubsystemTest("anonymous");
    }

    @Test
    public void testSequencingConfiguration() throws Exception {
        this.standardSubsystemTest("sequencing");
    }

    @Test
    public void testSchema() throws Exception {
        String subsystemXml = this.readResource("modeshape-sample-config.xml");
        this.validate(subsystemXml);
        KernelServices services = this.initKernel(subsystemXml);
        services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        this.validate(marshalled);
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/modeshape_2_0.xsd");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) {
                if (exception.getMessage().contains("cvc-enumeration-valid")) {
                    return;
                }
                if (exception.getMessage().contains("cvc-type")) {
                    return;
                }
                Assert.fail((String)exception.getMessage());
            }
        });
        validator.validate(source);
    }

    private static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    private void assertNode(ModelNode node, KeyValue ... values) {
        Assert.assertTrue((values.length > 0 ? 1 : 0) != 0);
        if (node.getType() == ModelType.LIST) {
            List modelNodes = node.asList();
            Assert.assertEquals((long)values.length, (long)modelNodes.size());
            for (int i = 0; i < modelNodes.size(); ++i) {
                this.assertNode((ModelNode)modelNodes.get(i), values[i]);
            }
        } else {
            values[0].assertEquals(node);
        }
    }

    private class KeyValue {
        private String key;
        private Object value;
        private ModelType type;

        protected KeyValue(String key, Object value, ModelType type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        protected KeyValue(String key, Object value) {
            this(key, value, ModelType.STRING);
        }

        protected void assertEquals(ModelNode node) {
            Object actualInstance = null;
            Assert.assertTrue((String)(this.key + " not present on ModelNode"), (boolean)node.has(this.key));
            switch (this.type) {
                case BIG_DECIMAL: {
                    actualInstance = node.get(this.key).asBigDecimal();
                    break;
                }
                case STRING: {
                    actualInstance = node.get(this.key).asString();
                    break;
                }
                case LONG: {
                    actualInstance = node.get(this.key).asLong();
                    break;
                }
                case BOOLEAN: {
                    actualInstance = node.get(this.key).asBoolean();
                    break;
                }
                default: {
                    actualInstance = node.get(this.key).asString();
                }
            }
            Assert.assertEquals((String)("Unexpected value in model node under " + this.key), (Object)this.value, (Object)actualInstance);
        }
    }
}

