/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.Base64;

public class JcrResourcesTest {
    private static final String SERVER_CONTEXT = "/modeshape-test";
    private static final String SERVER_URL = "http://localhost:8090/modeshape-test";

    @Before
    public void beforeEach() {
        String login = "dnauser";
        String password = "password";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("dnauser", "password".toCharArray());
            }
        });
    }

    private String getResponseFor(HttpURLConnection connection) throws IOException {
        int bytesRead;
        StringBuffer buff = new StringBuffer();
        InputStream stream = connection.getInputStream();
        byte[] bytes = new byte[1024];
        while (-1 != (bytesRead = stream.read(bytes, 0, 1024))) {
            buff.append(new String(bytes, 0, bytesRead));
        }
        return buff.toString();
    }

    @Test
    public void shouldNotServeContentToUnauthorizedUser() throws Exception {
        String login = "dnauser";
        String password = "invalidpassword";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("dnauser", "invalidpassword".toCharArray());
            }
        });
        URL postUrl = new URL("http://localhost:8090/modeshape-test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)401));
        connection.disconnect();
    }

    @Test
    public void shouldNotServeContentToUserWithoutConnectRole() throws Exception {
        String login = "unauthorizeduser";
        String password = "password";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("unauthorizeduser", "password".toCharArray());
            }
        });
        URL postUrl = new URL("http://localhost:8090/modeshape-test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)401));
        connection.disconnect();
    }

    @Test
    public void shouldServeContentAtRoot() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        JSONObject objFromResponse = new JSONObject(body);
        JSONObject expected = new JSONObject("{\"mode%3arepository\":{\"repository\":{\"name\":\"mode%3arepository\",\"resources\":{\"workspaces\":\"/modeshape-test/mode%3arepository\"}}}}");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)objFromResponse.toString(), (Matcher)Is.is((Object)expected.toString()));
        connection.disconnect();
    }

    @Test
    public void shouldServeListOfWorkspacesForValidRepository() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        JSONObject objFromResponse = new JSONObject(body);
        JSONObject expected = new JSONObject("{\"default\":{\"workspace\":{\"name\":\"default\",\"resources\":{\"query\":\"/modeshape-test/mode%3arepository/default/query\",\"items\":\"/modeshape-test/mode%3arepository/default/items\"}}}}");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)objFromResponse.toString(), (Matcher)Is.is((Object)expected.toString()));
        connection.disconnect();
    }

    @Test
    public void shouldReturnErrorForInvalidWorkspace() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/XXX");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveRootNodeForValidRepository() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:root"));
        Assert.assertThat((Object)properties.get("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONArray children = body.getJSONArray("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)children.getString(0), (Matcher)Is.is((Object)"jcr:system"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveRootNodeAndChildrenWhenDepthSet() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items?mode:depth=1");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:root"));
        Assert.assertThat((Object)properties.get("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        JSONObject system = children.getJSONObject("jcr:system");
        Assert.assertThat((Object)system.length(), (Matcher)Is.is((Object)2));
        properties = system.getJSONObject("properties");
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:system"));
        JSONArray namespaces = system.getJSONArray("children");
        Assert.assertThat((Object)namespaces.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)namespaces.getString(0), (Matcher)Is.is((Object)"jcr:versionStorage"));
        Assert.assertThat((Object)namespaces.getString(1), (Matcher)Is.is((Object)"mode:namespaces"));
        Assert.assertThat((Object)namespaces.getString(2), (Matcher)Is.is((Object)"mode:locks"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveNodeAndChildrenWhenDepthSet() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/jcr:system?mode:depth=1");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:system"));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)3));
        JSONObject namespaces = children.getJSONObject("mode:namespaces");
        Assert.assertThat((Object)namespaces.length(), (Matcher)Is.is((Object)2));
        JSONObject locks = children.getJSONObject("mode:locks");
        Assert.assertThat((Object)locks.length(), (Matcher)Is.is((Object)1));
        JSONObject versionStorage = children.getJSONObject("jcr:versionStorage");
        Assert.assertThat((Object)versionStorage.length(), (Matcher)Is.is((Object)1));
        properties = namespaces.getJSONObject("properties");
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:namespaces"));
        JSONArray namespace = namespaces.getJSONArray("children");
        Assert.assertThat((Object)namespace.length(), (Matcher)Is.is((Object)10));
        HashSet<String> prefixes = new HashSet<String>(namespace.length());
        for (int i = 0; i < namespace.length(); ++i) {
            prefixes.add(namespace.getString(i));
        }
        String[] expectedNamespaces = new String[]{"mode", "jcr", "nt", "mix", "sv", "xml", "modeint", "xmlns", "xsi", "xs"};
        for (int i = 0; i < expectedNamespaces.length; ++i) {
            Assert.assertTrue((boolean)prefixes.contains(expectedNamespaces[i]));
        }
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldNotRetrieveNonExistentNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/foo");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotRetrieveNonExistentProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/jcr:system/foobar");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/jcr:system/jcr:primaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        Assert.assertThat((Object)body, (Matcher)Is.is((Object)"{\"jcr:primaryType\":\"mode:system\"}"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeA");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithoutPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/noPrimaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithMixinTypes() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/withMixinType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:mixinTypes\": \"mix:referenceable\"}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONArray values = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/withMixinType");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        values = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldNotPostNodeAtInvalidParentPath() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/foo/bar");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotPostNodeWithInvalidPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/invalidPrimaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"invalidType\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)400));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/invalidPrimaryType");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeHierarchy() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nestedPost");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}, \"children\": { \"childNode\" : { \"properties\": {\"nestedProperty\": \"nestedValue\"}}}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nestedPost?mode:depth=1");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        JSONObject child = children.getJSONObject("childNode");
        Assert.assertThat((Object)child, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)child.length(), (Matcher)Is.is((Object)1));
        properties = child.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("nestedProperty"), (Matcher)Is.is((Object)"nestedValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldFailWholeTransactionIfOneNodeIsBad() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/invalidNestedPost");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}, \"children\": { \"childNode\" : { \"properties\": {\"jcr:primaryType\": \"invalidType\"}}}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)400));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/invalidNestedPost?mode:depth=1");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotDeleteNonExistentItem() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/invalidItemForDelete");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldDeleteExtantNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForDeletion");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)204));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldDeleteExtantProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/propertyForDeletion");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/propertyForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/propertyForDeletion/multiValuedProperty");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)204));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/propertyForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldNotBeAbleToPutAtInvalidPath() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nonexistantNode");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"firstProperty\": \"someValue\" }";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutValueToProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutProperty");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutProperty/testProperty");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"testProperty\":\"someOtherValue\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"someOtherValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutBinaryValueToProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutBinaryProperty");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String encodedValue = Base64.encodeBytes((byte[])"propertyValue".getBytes("UTF-8"));
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty/base64/\": \"" + encodedValue + "\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        URL putUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutBinaryProperty/testProperty");
        connection = (HttpURLConnection)putUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String otherValue = "someOtherValue";
        payload = "{\"testProperty/base64/\":\"" + Base64.encodeBytes((byte[])otherValue.getBytes("UTF-8")) + "\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        String responseEncodedValue = properties.getString("testProperty/base64/");
        String decodedValue = new String(Base64.decode((String)responseEncodedValue), "UTF-8");
        Assert.assertThat((Object)decodedValue, (Matcher)Is.is((Object)otherValue));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        connection = (HttpURLConnection)putUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String anotherValue = "yetAnotherValue";
        payload = "{\"testProperty\":\"" + anotherValue + "\"}";
        connection.getOutputStream().write(payload.getBytes());
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)anotherValue));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutPropertiesToNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutProperties");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeForPutProperties");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToAddAndRemoveMixinTypes() throws Exception {
        URL postUrl = new URL("http://localhost:8090/modeshape-test/mode%3arepository/default/items/nodeWithNoMixins");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"jcr:mixinTypes\": \"mix:referenceable\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        JSONArray mixinTypes = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)mixinTypes, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)mixinTypes.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)mixinTypes.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"jcr:mixinTypes\": []}";
        connection.getOutputStream().write(payload.getBytes());
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        mixinTypes = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)mixinTypes, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)mixinTypes.length(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }
}

