/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.jca.JcrManagedConnection;
import org.modeshape.jca.JcrManagedConnectionFactory;
import org.modeshape.jca.JcrResourceAdapter;
import org.modeshape.jcr.AbstractTransactionalTest;

@RunWith(value=Arquillian.class)
public class ConnectorTestCase
extends AbstractTransactionalTest {
    private static Logger log = Logger.getLogger("ConnectorTestCase");
    private static String deploymentName = "ConnectorTestCase";
    @Resource(mappedName="java:/eis/JcrCciConnectionFactory")
    private Repository repository;

    @Deployment
    public static ResourceAdapterArchive createDeployment() {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)(deploymentName + ".rar"));
        JavaArchive ja = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(UUID.randomUUID().toString() + ".jar"));
        ja.addClasses(new Class[]{JcrResourceAdapter.class, JcrManagedConnectionFactory.class, JcrManagedConnection.class});
        ja.addAsResource("my-repository-config.json");
        raa.addAsLibrary((Archive)ja);
        raa.addAsManifestResource("META-INF/ironjacamar.xml", "ironjacamar.xml");
        raa.addAsResource("my-repository-config.json");
        return raa;
    }

    @Test
    public void testGetConnection() throws Throwable {
        Assert.assertNotNull((Object)this.repository);
        Session session = this.repository.login();
        Assert.assertNotNull((Object)session);
        Node node = session.getRootNode();
        Assert.assertNotNull((Object)node);
        session.logout();
    }
}

