/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.cache;

import java.io.IOException;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.collections.IntArray;

public class CategoryListData {
    private volatile transient int[][][] docPartitionCategories;

    protected CategoryListData() {
    }

    CategoryListData(IndexReader reader, TaxonomyReader taxo, FacetIndexingParams iparams, CategoryListParams clp) throws IOException {
        int maxDoc = reader.maxDoc();
        int[][][] dpf = new int[maxDoc][][];
        int numPartitions = (int)Math.ceil((double)taxo.getSize() / (double)iparams.getPartitionSize());
        IntArray docCategories = new IntArray();
        for (int part = 0; part < numPartitions; ++part) {
            CategoryListIterator cli = clp.createCategoryListIterator(reader, part);
            if (!cli.init()) continue;
            for (int doc = 0; doc < maxDoc; ++doc) {
                long category;
                if (!cli.skipTo(doc)) continue;
                docCategories.clear(false);
                if (dpf[doc] == null) {
                    dpf[doc] = new int[numPartitions][];
                }
                while ((category = cli.nextCategory()) <= Integer.MAX_VALUE) {
                    docCategories.addToArray((int)category);
                }
                int size = docCategories.size();
                dpf[doc][part] = new int[size];
                for (int i = 0; i < size; ++i) {
                    dpf[doc][part][i] = docCategories.get(i);
                }
            }
        }
        this.docPartitionCategories = dpf;
    }

    public CategoryListIterator iterator(int partition) throws IOException {
        return new RAMCategoryListIterator(partition, this.docPartitionCategories);
    }

    private static class RAMCategoryListIterator
    implements CategoryListIterator {
        private final int part;
        private final int[][][] dpc;
        private int currDoc = -1;
        private int nextCategoryIndex = -1;

        RAMCategoryListIterator(int part, int[][][] docPartitionCategories) {
            this.part = part;
            this.dpc = docPartitionCategories;
        }

        public boolean init() throws IOException {
            return this.dpc != null && this.dpc.length > this.part;
        }

        public long nextCategory() throws IOException {
            if (this.nextCategoryIndex >= this.dpc[this.currDoc][this.part].length) {
                return 0x80000000L;
            }
            return this.dpc[this.currDoc][this.part][this.nextCategoryIndex++];
        }

        public boolean skipTo(int docId) throws IOException {
            boolean res;
            boolean bl = res = this.dpc.length > docId && this.dpc[docId] != null && this.dpc[docId][this.part] != null;
            if (res) {
                this.currDoc = docId;
                this.nextCategoryIndex = 0;
            }
            return res;
        }
    }
}

