/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.sampling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FloatArrayAllocator;
import org.apache.lucene.facet.search.IntArrayAllocator;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.sampling.Sampler;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplingAccumulator
extends StandardFacetsAccumulator {
    private double samplingRatio = -1.0;
    private final Sampler sampler;

    public SamplingAccumulator(Sampler sampler, FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, IntArrayAllocator intArrayAllocator, FloatArrayAllocator floatArrayAllocator) {
        super(searchParams, indexReader, taxonomyReader, intArrayAllocator, floatArrayAllocator);
        this.sampler = sampler;
    }

    public SamplingAccumulator(Sampler sampler, FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        super(searchParams, indexReader, taxonomyReader);
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        boolean origAllowLabeling = this.isAllowLabeling();
        this.setAllowLabeling(false);
        FacetSearchParams original = this.searchParams;
        this.searchParams = this.sampler.overSampledSearchParams(original);
        List<FacetResult> sampleRes = super.accumulate(docids);
        this.setAllowLabeling(origAllowLabeling);
        ArrayList<FacetResult> fixedRes = new ArrayList<FacetResult>();
        for (FacetResult fres : sampleRes) {
            FacetResultsHandler frh = fres.getFacetRequest().createFacetResultsHandler(this.taxonomyReader);
            this.sampler.getSampleFixer(this.indexReader, this.taxonomyReader, this.searchParams).fixResult(docids, fres);
            fres = frh.rearrangeFacetResult(fres);
            fres = this.sampler.trimResult(fres);
            if (this.isAllowLabeling()) {
                frh.labelResult(fres);
            }
            fixedRes.add(fres);
        }
        this.searchParams = original;
        return fixedRes;
    }

    @Override
    protected ScoredDocIDs actualDocsToAccumulate(ScoredDocIDs docids) throws IOException {
        Sampler.SampleResult sampleRes = this.sampler.getSampleSet(docids);
        this.samplingRatio = sampleRes.actualSampleRatio;
        return sampleRes.docids;
    }

    @Override
    protected double getTotalCountsFactor() {
        if (this.samplingRatio < 0.0) {
            throw new IllegalStateException("Total counts ratio unavailable because actualDocsToAccumulate() was not invoked");
        }
        return this.samplingRatio;
    }
}

