/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki;

import org.jboss.papaki.AnnotationScanner;
import org.jboss.papaki.Configuration;
import org.jboss.papaki.javalangreflect.JavaClass;
import org.jboss.papaki.javassistclasspool.JavassistClassPool;
import org.jboss.papaki.javassistinputstream.JavassistInputStream;

public class AnnotationScannerFactory {
    public static final int JAVASSIST_CLASS_POOL = 0;
    public static final int JAVASSIST_INPUT_STREAM = 1;
    public static final int JAVA_LANG_REFLECT = 2;
    private static int defaultStrategy;
    static boolean haveJavassist;

    private AnnotationScannerFactory() {
    }

    public static AnnotationScanner getDefault() {
        return AnnotationScannerFactory.getStrategy(defaultStrategy);
    }

    public static AnnotationScanner getDefault(Configuration configuration) {
        return AnnotationScannerFactory.getStrategy(defaultStrategy, configuration);
    }

    public static AnnotationScanner getStrategy(int strategy) {
        return AnnotationScannerFactory.getStrategy(strategy, null);
    }

    public static AnnotationScanner getStrategy(int strategy, Configuration configuration) {
        if (strategy < 0 || strategy > 2) {
            throw new IllegalArgumentException("Unknown strategy key");
        }
        if (strategy == 0) {
            if (haveJavassist) {
                return new JavassistClassPool(configuration);
            }
            throw new IllegalArgumentException("Javassist not available");
        }
        if (strategy == 1) {
            if (haveJavassist) {
                return new JavassistInputStream(configuration);
            }
            throw new IllegalArgumentException("Javassist not available");
        }
        return new JavaClass(configuration);
    }

    static {
        haveJavassist = false;
        try {
            Class.forName("javassist.CtClass");
            haveJavassist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        defaultStrategy = haveJavassist ? 1 : 2;
    }
}

