/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ExtensionScanner {
    private ExtensionScanner() {
    }

    public static List<File> scan(File root, String extension) {
        try {
            return ExtensionScanner.getFileListing(root, extension);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static List<File> getFileListing(File aStartingDir, String extension) throws Exception {
        List<File> result = ExtensionScanner.getFileListingNoSort(aStartingDir, extension);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir, String extension) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile()) {
                if (!file.getName().endsWith(extension)) continue;
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = ExtensionScanner.getFileListingNoSort(file, extension);
            result.addAll(deeperList);
        }
        return result;
    }
}

