/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.papaki.util.ExtensionScanner;

public class JarScanner {
    private static Logger log = Logger.getLogger(JarScanner.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);

    private JarScanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> scan(File root) {
        ArrayList<String> result = new ArrayList<String>();
        log.fine("Scanning " + root);
        List<Object> jarFiles = null;
        if (root.isFile()) {
            jarFiles = new ArrayList();
            jarFiles.add(root);
        } else {
            jarFiles = ExtensionScanner.scan(root, ".jar");
        }
        for (File file : jarFiles) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".class")) continue;
                    name = name.replace('/', '.');
                    name = name.substring(0, name.lastIndexOf(".class"));
                    if (trace) {
                        log.finest("Class=" + name);
                    }
                    result.add(name);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                try {
                    if (jar == null) continue;
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
        return result;
    }
}

