/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Random;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareDldGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.util.ClusterIdGenerator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionFactory {
    private static final Log log = LogFactory.getLog(TransactionFactory.class);
    private TxFactoryEnum txFactoryEnum;
    private EmbeddedCacheManager cm;
    private Configuration configuration;
    private ClusterIdGenerator clusterIdGenerator;
    private boolean isClustered;
    private RpcManager rpcManager;

    public GlobalTransaction newGlobalTransaction() {
        return this.txFactoryEnum.newGlobalTransaction();
    }

    public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
        return this.txFactoryEnum.newGlobalTransaction(addr, remote, this.clusterIdGenerator, this.isClustered);
    }

    public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
        return this.txFactoryEnum.newLocalTransaction(tx, gtx, implicitTransaction, topologyId);
    }

    public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
        return this.txFactoryEnum.newRemoteTransaction(modifications, tx, topologyId);
    }

    public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
        return this.txFactoryEnum.newRemoteTransaction(tx, topologyId);
    }

    @Inject
    public void init(Configuration configuration, EmbeddedCacheManager cm, RpcManager rpcManager) {
        this.cm = cm;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
    }

    @Start
    public void start() {
        boolean dldEnabled = this.configuration.deadlockDetection().enabled();
        boolean xa = !this.configuration.transaction().useSynchronization();
        boolean recoveryEnabled = this.configuration.transaction().recovery().enabled();
        boolean batchingEnabled = this.configuration.invocationBatching().enabled();
        this.init(dldEnabled, recoveryEnabled, xa, batchingEnabled);
        this.isClustered = this.configuration.clustering().cacheMode().isClustered();
        if (recoveryEnabled) {
            Transport transport = this.rpcManager != null ? this.rpcManager.getTransport() : null;
            this.clusterIdGenerator = new ClusterIdGenerator(this.cm, transport);
        }
    }

    public void init(boolean dldEnabled, boolean recoveryEnabled, boolean xa, boolean batchingEnabled) {
        this.txFactoryEnum = batchingEnabled ? (dldEnabled ? TxFactoryEnum.DLD_NORECOVERY_NOXA : TxFactoryEnum.NODLD_NORECOVERY_NOXA) : (dldEnabled ? (recoveryEnabled ? (xa ? TxFactoryEnum.DLD_RECOVERY_XA : TxFactoryEnum.DLD_NORECOVERY_NOXA) : (xa ? TxFactoryEnum.DLD_NORECOVERY_XA : TxFactoryEnum.DLD_NORECOVERY_NOXA)) : (recoveryEnabled ? (xa ? TxFactoryEnum.NODLD_RECOVERY_XA : TxFactoryEnum.NODLD_NORECOVERY_NOXA) : (xa ? TxFactoryEnum.NODLD_NORECOVERY_XA : TxFactoryEnum.NODLD_NORECOVERY_NOXA)));
        log.tracef("Setting factory enum to %s", (Object)this.txFactoryEnum);
    }

    public static enum TxFactoryEnum {
        DLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new RecoveryAwareLocalTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                RecoveryAwareDldGlobalTransaction dldGlobalTransaction = new RecoveryAwareDldGlobalTransaction(addr, remote);
                dldGlobalTransaction.setInternalId(clusterIdGenerator.newVersion(clustered));
                return this.addCoinToss(dldGlobalTransaction);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareDldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RecoveryAwareRemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RecoveryAwareRemoteTransaction(tx, topologyId);
            }
        }
        ,
        DLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new LocalXaTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return this.addCoinToss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(tx, topologyId);
            }
        }
        ,
        DLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new SyncLocalTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return this.addCoinToss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(tx, topologyId);
            }
        }
        ,
        NODLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new RecoveryAwareLocalTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                RecoveryAwareGlobalTransaction recoveryAwareGlobalTransaction = new RecoveryAwareGlobalTransaction(addr, remote);
                recoveryAwareGlobalTransaction.setInternalId(clusterIdGenerator.newVersion(clustered));
                return recoveryAwareGlobalTransaction;
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RecoveryAwareRemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RecoveryAwareRemoteTransaction(tx, topologyId);
            }
        }
        ,
        NODLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new LocalXaTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(tx, topologyId);
            }
        }
        ,
        NODLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
                return new SyncLocalTransaction(tx, gtx, implicitTransaction, topologyId);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(modifications, tx, topologyId);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
                return new RemoteTransaction(tx, topologyId);
            }
        };

        private final Random rnd = new Random();

        public abstract LocalTransaction newLocalTransaction(Transaction var1, GlobalTransaction var2, boolean var3, int var4);

        public abstract GlobalTransaction newGlobalTransaction(Address var1, boolean var2, ClusterIdGenerator var3, boolean var4);

        public abstract GlobalTransaction newGlobalTransaction();

        protected long generateRandomId() {
            return this.rnd.nextLong();
        }

        protected GlobalTransaction addCoinToss(DldGlobalTransaction dldGlobalTransaction) {
            dldGlobalTransaction.setCoinToss(this.generateRandomId());
            return dldGlobalTransaction;
        }

        public abstract RemoteTransaction newRemoteTransaction(WriteCommand[] var1, GlobalTransaction var2, int var3);

        public abstract RemoteTransaction newRemoteTransaction(GlobalTransaction var1, int var2);
    }
}

