/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.papaki.AnnotationType;

public class Annotation {
    private static Logger log = Logger.getLogger(Annotation.class.getName());
    private String annotationClassName;
    private Object annotation;
    private AnnotationType type;
    private String className;
    private String memberName;
    private List<String> parameterTypes;
    private int parameterIndex;
    private Integer hashCode;

    public Annotation(String annotationClassName, Object annotation, AnnotationType type, String className, String memberName, String[] parameterTypes, int parameterIndex) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException("AnnotationClassName is null");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (className == null) {
            throw new IllegalArgumentException("ClassName is null");
        }
        this.annotationClassName = annotationClassName;
        this.annotation = annotation;
        this.type = type;
        this.className = className;
        this.memberName = memberName;
        this.parameterTypes = null;
        this.parameterIndex = parameterIndex;
        if (parameterTypes != null) {
            this.parameterTypes = new ArrayList<String>(parameterTypes.length);
            for (String s : parameterTypes) {
                this.parameterTypes.add(s);
            }
        }
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public Object getAnnotation() {
        return this.annotation;
    }

    public AnnotationType getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String[] getParameterTypes() {
        if (this.parameterTypes == null) {
            return null;
        }
        return this.parameterTypes.toArray(new String[this.parameterTypes.size()]);
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    private int calculateHashCode() {
        int result = 7;
        result += 7 * this.annotationClassName.hashCode();
        result += 7 * this.annotation.getClass().getName().hashCode();
        result += 7 * this.type.hashCode();
        result += 7 * this.className.hashCode();
        result += 7 * (this.memberName != null ? this.memberName.hashCode() : 1);
        result += 7 * (this.parameterTypes != null ? ((Object)this.parameterTypes).hashCode() : 1);
        return result += 7 * this.parameterIndex;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.calculateHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Annotation)) {
            return false;
        }
        Annotation a = (Annotation)other;
        boolean result = true;
        result = this.annotationClassName.equals(a.getAnnotationClassName());
        if (result) {
            result = this.type.equals((Object)a.getType());
        }
        if (result) {
            result = this.className.equals(a.getClassName());
        }
        if (result) {
            result = this.memberName == null ? a.getMemberName() == null : this.memberName.equals(a.getMemberName());
        }
        if (result) {
            result = this.parameterTypes == null ? a.getParameterTypes() == null : Arrays.equals(this.getParameterTypes(), a.getParameterTypes());
        }
        if (result) {
            result = this.parameterIndex == a.getParameterIndex();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb = sb.append(this.getClass().getName());
        sb = sb.append("[");
        sb = sb.append("AnnotationClass=" + this.annotationClassName + ",");
        sb = sb.append("Annotation=" + this.annotation + ",");
        sb = sb.append("Type=" + (Object)((Object)this.type) + ",");
        sb = sb.append("Class=" + this.className + ",");
        sb = sb.append("Member=" + this.memberName + ",");
        sb = sb.append("Parameters=" + this.parameterTypes);
        sb = sb.append("ParameterIndex=" + this.parameterIndex);
        sb = sb.append("]");
        return sb.toString();
    }
}

