/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.papaki.AnnotationRepository;
import org.jboss.papaki.AnnotationScanner;
import org.jboss.papaki.Configuration;
import org.jboss.papaki.Settings;
import org.jboss.papaki.Visibility;
import org.jboss.papaki.impl.AnnotationRepositoryImpl;
import org.jboss.papaki.impl.ConfigurationImpl;
import org.jboss.papaki.impl.SettingsImpl;
import org.jboss.papaki.util.BinaryLoader;
import org.jboss.papaki.util.ClassScanner;
import org.jboss.papaki.util.JarScanner;

public abstract class AbstractAnnotationScanner
implements AnnotationScanner {
    private Logger log;
    private boolean trace;
    public static final String PAPAKI_METADATA_BINARY = "papaki.ser";
    private Configuration configuration;

    public AbstractAnnotationScanner(String logger) {
        this.log = Logger.getLogger(logger);
        this.trace = this.log.isLoggable(Level.FINEST);
    }

    @Override
    public Configuration configure() {
        if (this.configuration == null) {
            this.configuration = new ConfigurationImpl();
        }
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected List<String> getClassNames(URL[] urls) {
        ArrayList<String> result = new ArrayList<String>();
        for (URL url : urls) {
            try {
                this.log.fine("Checking " + url);
                if ("file".equals(url.getProtocol())) {
                    long start = 0L;
                    if (this.log.isLoggable(Level.FINE)) {
                        start = System.currentTimeMillis();
                    }
                    File f = new File(url.toURI());
                    List<String> classFiles = null;
                    if (f.exists()) {
                        classFiles = f.isDirectory() ? ClassScanner.scan(f) : JarScanner.scan(f);
                    }
                    if (classFiles != null) {
                        result.addAll(classFiles);
                    }
                    if (!this.log.isLoggable(Level.FINE)) continue;
                    long end = System.currentTimeMillis();
                    this.log.fine("Retrieving classes took " + (end - start) + " ms for " + url.getFile());
                    continue;
                }
                this.log.warning("Protocol not supported: " + url);
            }
            catch (URISyntaxException use) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotationRepositoryImpl getScan(JarFile jarFile) {
        AnnotationRepositoryImpl result = null;
        InputStream binaryIS = null;
        try {
            JarEntry binary = jarFile.getJarEntry("META-INF/papaki.ser");
            if (binary != null) {
                binaryIS = jarFile.getInputStream(binary);
                result = BinaryLoader.loadJBossAnnotation(binaryIS);
            }
        }
        catch (Throwable t) {
            if (this.trace) {
                this.log.finest(t.getMessage());
            }
        }
        finally {
            if (binaryIS != null) {
                try {
                    binaryIS.close();
                }
                catch (IOException ioe) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotationRepositoryImpl getScan(File directory) {
        AnnotationRepositoryImpl result = null;
        InputStream binaryIS = null;
        try {
            File binary = new File(directory, "META-INF/papaki.ser");
            if (binary != null && binary.exists()) {
                binaryIS = new BufferedInputStream(new FileInputStream(binary));
                result = BinaryLoader.loadJBossAnnotation(binaryIS);
            }
        }
        catch (Throwable t) {
            if (this.trace) {
                this.log.finest(t.getMessage());
            }
        }
        finally {
            if (binaryIS != null) {
                try {
                    binaryIS.close();
                }
                catch (IOException ioe) {}
            }
        }
        return result;
    }

    protected boolean includeClass(int modifiers) {
        return this.includeVisibility(this.configure().getClassVisibility(), modifiers);
    }

    protected boolean includeField(int modifiers) {
        return this.includeVisibility(this.configure().getFieldVisibility(), modifiers);
    }

    protected boolean includeConstructor(int modifiers) {
        return this.includeVisibility(this.configure().getConstructorVisibility(), modifiers);
    }

    protected boolean includeMethod(int modifiers) {
        return this.includeVisibility(this.configure().getMethodVisibility(), modifiers);
    }

    protected Settings getSettings() {
        return new SettingsImpl(this.configure().isClassLevel(), this.configure().getClassVisibility(), this.configure().isFieldLevel(), this.configure().getFieldVisibility(), this.configure().isConstructorLevel(), this.configure().getConstructorVisibility(), this.configure().isMethodLevel(), this.configure().getMethodVisibility(), this.configure().isParameterLevel());
    }

    private boolean includeVisibility(Visibility v, int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        boolean include = true;
        if (Modifier.isPrivate(modifiers)) {
            if (v == Visibility.PROTECTED || v == Visibility.PACKAGE || v == Visibility.PUBLIC) {
                include = false;
            }
        } else if (Modifier.isProtected(modifiers)) {
            if (v == Visibility.PACKAGE || v == Visibility.PUBLIC) {
                include = false;
            }
        } else if (v == Visibility.PUBLIC) {
            include = false;
        }
        return include;
    }

    @Override
    public AnnotationRepository scan(URL[] urls) {
        return this.scan(urls, new ClassLoader[]{null});
    }

    @Override
    public abstract AnnotationRepository scan(URL[] var1, ClassLoader ... var2);
}

