/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.papaki.Annotation;
import org.jboss.papaki.AnnotationType;
import org.jboss.papaki.impl.AbstractAnnotationScanner;
import org.jboss.papaki.impl.AnnotationRepositoryImpl;
import org.jboss.papaki.impl.ClassInfo;

public abstract class AbstractJavassistAnnotationScanner
extends AbstractAnnotationScanner {
    private Logger log;
    private boolean trace;

    public AbstractJavassistAnnotationScanner(String logger) {
        super(logger);
        this.log = Logger.getLogger(logger);
        this.trace = this.log.isLoggable(Level.FINEST);
    }

    protected void processClass(CtClass ctClass, AnnotationRepositoryImpl ari, Map<String, Collection<String>> annotationToClasses, Map<String, ClassInfo> classInfo) throws NotFoundException {
        CtClass[] interfaces;
        CtField[] fields;
        CtMethod[] methods;
        int j;
        int i;
        Object[][] parameterAnnotations;
        Object annotation3;
        CtClass[] parameters;
        String[] parameterTypes;
        CtConstructor[] constructors;
        Object[] classAnnotations;
        if (this.trace) {
            this.log.finest("Class=" + ctClass.getName());
        }
        if (ari != null && !ari.shouldBeScanned(ctClass.getName())) {
            return;
        }
        if (!this.includeClass(ctClass.getModifiers())) {
            return;
        }
        ClassInfo ci = null;
        if (ari == null) {
            ci = classInfo.get(ctClass.getName());
            if (ci == null) {
                ci = new ClassInfo(ctClass.getName());
            }
            if (ctClass.getSuperclass() != null && !ctClass.getSuperclass().getName().startsWith("java.")) {
                ClassInfo sci = classInfo.get(ctClass.getSuperclass().getName());
                if (sci == null) {
                    sci = new ClassInfo(ctClass.getSuperclass().getName());
                }
                sci.addChild(ctClass.getName());
                classInfo.put(ctClass.getSuperclass().getName(), sci);
            }
            ci.setInterface(ctClass.isInterface());
            ci.setAbstract(Modifier.isAbstract((int)ctClass.getModifiers()));
            classInfo.put(ctClass.getName(), ci);
        }
        if (this.configure().isClassLevel() && (classAnnotations = ctClass.getAvailableAnnotations()) != null) {
            for (Object annotation2 : classAnnotations) {
                this.processAnnotation(annotation2, AnnotationType.CLASS, ctClass.getName(), null, null, -1, ari, annotationToClasses, classInfo);
            }
        }
        if (!ctClass.isInterface() && this.configure().isConstructorLevel() && (constructors = ctClass.getDeclaredConstructors()) != null) {
            for (CtConstructor constructor : constructors) {
                Object[] constructorAnnotations;
                if (this.trace) {
                    this.log.finest("Constructor=" + constructor.getName());
                }
                if (!this.includeConstructor(constructor.getModifiers())) continue;
                parameterTypes = null;
                parameters = constructor.getParameterTypes();
                if (parameters != null && parameters.length > 0) {
                    parameterTypes = new String[parameters.length];
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        parameterTypes[i2] = parameters[i2].getName();
                        if (!this.trace) continue;
                        this.log.finest("Parameter=" + parameters[i2].getName());
                    }
                }
                if ((constructorAnnotations = constructor.getAvailableAnnotations()) != null) {
                    for (Object annotation3 : constructorAnnotations) {
                        this.processAnnotation(annotation3, AnnotationType.CONSTRUCTOR, ctClass.getName(), null, parameterTypes, -1, ari, annotationToClasses, classInfo);
                    }
                }
                if (parameterTypes == null || !this.configure().isParameterLevel()) continue;
                parameterAnnotations = constructor.getAvailableParameterAnnotations();
                for (i = 0; i < parameterAnnotations.length; ++i) {
                    for (j = 0; j < parameterAnnotations[i].length; ++j) {
                        annotation3 = parameterAnnotations[i][j];
                        this.processAnnotation(annotation3, AnnotationType.PARAMETER, ctClass.getName(), null, parameterTypes, i, ari, annotationToClasses, classInfo);
                    }
                }
            }
        }
        if (this.configure().isMethodLevel() && (methods = ctClass.getDeclaredMethods()) != null) {
            for (CtMethod method : methods) {
                Object[] methodAnnotations;
                if (this.trace) {
                    this.log.finest("Method=" + method.getName());
                }
                if (!this.includeMethod(method.getModifiers())) continue;
                parameterTypes = null;
                parameters = method.getParameterTypes();
                if (parameters != null && parameters.length > 0) {
                    parameterTypes = new String[parameters.length];
                    for (int i3 = 0; i3 < parameters.length; ++i3) {
                        parameterTypes[i3] = parameters[i3].getName();
                        if (!this.trace) continue;
                        this.log.finest("Parameter=" + parameters[i3].getName());
                    }
                }
                if ((methodAnnotations = method.getAvailableAnnotations()) != null) {
                    for (Object annotation3 : methodAnnotations) {
                        this.processAnnotation(annotation3, AnnotationType.METHOD, ctClass.getName(), method.getName(), parameterTypes, -1, ari, annotationToClasses, classInfo);
                    }
                }
                if (parameterTypes == null || !this.configure().isParameterLevel()) continue;
                parameterAnnotations = method.getAvailableParameterAnnotations();
                for (i = 0; i < parameterAnnotations.length; ++i) {
                    for (j = 0; j < parameterAnnotations[i].length; ++j) {
                        annotation3 = parameterAnnotations[i][j];
                        this.processAnnotation(annotation3, AnnotationType.PARAMETER, ctClass.getName(), method.getName(), parameterTypes, i, ari, annotationToClasses, classInfo);
                    }
                }
            }
        }
        if (!ctClass.isInterface() && this.configure().isFieldLevel() && (fields = ctClass.getDeclaredFields()) != null) {
            for (CtField field : fields) {
                Object[] fieldAnnotations;
                if (this.trace) {
                    this.log.finest("Field=" + field.getName());
                }
                if ((fieldAnnotations = field.getAvailableAnnotations()) == null) continue;
                for (Object annotation4 : fieldAnnotations) {
                    this.processAnnotation(annotation4, AnnotationType.FIELD, ctClass.getName(), field.getName(), null, -1, ari, annotationToClasses, classInfo);
                }
            }
        }
        if (ari == null && (interfaces = ctClass.getInterfaces()) != null) {
            for (CtClass interfaceClass : interfaces) {
                String interfaceName = interfaceClass.getName();
                if (interfaceName.startsWith("java.")) continue;
                ClassInfo ici = classInfo.get(interfaceName);
                if (ici == null) {
                    ici = new ClassInfo(interfaceName);
                }
                ici.addChild(ctClass.getName());
                classInfo.put(interfaceName, ici);
            }
        }
    }

    protected void processAnnotation(Object annotation, AnnotationType type, String className, String memberName, String[] parameterTypes, int parameterIndex, AnnotationRepositoryImpl ari, Map<String, Collection<String>> annotationToClasses, Map<String, ClassInfo> classInfo) {
        Class<?> annotationClass = annotation.getClass().getInterfaces()[0];
        String acn = annotationClass.getName();
        Annotation a = new Annotation(acn, annotationClass.cast(annotation), type, className, memberName, parameterTypes, parameterIndex);
        if (this.trace) {
            this.log.finest("Annotation=" + a);
        }
        if (ari != null) {
            ari.registerAnnotation(className, acn, a);
        } else {
            Collection<String> l = annotationToClasses.get(acn);
            if (l == null) {
                l = new HashSet<String>();
            }
            l.add(className);
            annotationToClasses.put(acn, l);
            ClassInfo ci = classInfo.get(className);
            ci.addAnnotation(acn, a);
        }
    }
}

