/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.papaki.Annotation;

public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className;
    private boolean isInterface;
    private boolean isAbstract;
    private transient Map<String, Collection<Annotation>> annotations;
    private Collection<String> children;

    public ClassInfo(String className) {
        if (className == null) {
            throw new IllegalArgumentException("ClassName is null");
        }
        this.className = className;
        this.isInterface = false;
        this.isAbstract = false;
        this.annotations = null;
        this.children = null;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public Collection<Annotation> getAnnotations() {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (this.annotations != null) {
            for (Collection<Annotation> c : this.annotations.values()) {
                result.addAll(c);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public Collection<Annotation> getAnnotations(String clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(clz);
    }

    public void addAnnotation(String key, Annotation annotation) {
        Collection<Annotation> c;
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Collection<Annotation>>(1);
        }
        if ((c = this.annotations.get(key)) == null) {
            c = new HashSet<Annotation>(1);
        }
        c.add(annotation);
        this.annotations.put(key, c);
    }

    public Collection<String> getChildren() {
        return this.children;
    }

    public void addChild(String clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        if (this.children == null) {
            this.children = new HashSet<String>(1);
        }
        this.children.add(clz);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ClassInfo.class.getName());
        sb = sb.append("{");
        sb = sb.append("ClassName=" + this.className + ",");
        sb = sb.append("Annotations=" + this.annotations + ",");
        sb = sb.append("IsInterface=" + this.isInterface + ",");
        sb = sb.append("IsAbstract=" + this.isAbstract + ",");
        sb = sb.append("Children=" + this.children);
        sb = sb.append("}");
        return sb.toString();
    }
}

