/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.javassistclasspool;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.papaki.AnnotationRepository;
import org.jboss.papaki.Configuration;
import org.jboss.papaki.impl.AbstractJavassistAnnotationScanner;
import org.jboss.papaki.impl.AnnotationRepositoryImpl;
import org.jboss.papaki.impl.ClassInfo;
import org.jboss.papaki.javassistclasspool.SecurityActions;

public class JavassistClassPool
extends AbstractJavassistAnnotationScanner {
    private static Logger log = Logger.getLogger(JavassistClassPool.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);

    public JavassistClassPool() {
        super(JavassistClassPool.class.getName());
    }

    public JavassistClassPool(Configuration configuration) {
        this();
        this.setConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationRepository scan(URL[] urls, ClassLoader ... cls) {
        HashMap<String, Collection<String>> annotationToClasses = new HashMap<String, Collection<String>>();
        HashMap<String, ClassInfo> classInfo = new HashMap<String, ClassInfo>();
        AnnotationRepositoryImpl ari = null;
        long start = 0L;
        if (log.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        if (urls != null) {
            URLClassLoader cl = SecurityActions.createURLClassLoader(urls, SecurityActions.getThreadContextClassLoader());
            ClassPool cp = new ClassPool();
            cp.appendClassPath((ClassPath)new LoaderClassPath((ClassLoader)cl));
            if (cls != null) {
                for (ClassLoader c : cls) {
                    cp.appendClassPath((ClassPath)new LoaderClassPath(c));
                }
            }
            for (URL u : urls) {
                ZipFile jar = null;
                try {
                    List<String> classes;
                    File jarFile = new File(u.toURI());
                    if (!jarFile.exists()) continue;
                    if (jarFile.isFile()) {
                        jar = new JarFile(jarFile);
                        ari = this.getScan((JarFile)jar);
                    } else {
                        ari = this.getScan(jarFile);
                    }
                    if (ari != null && ari.getSize() == 0 || (classes = this.getClassNames(new URL[]{u})) == null) continue;
                    for (String className : classes) {
                        try {
                            CtClass ctClass = cp.get(className);
                            if (ctClass.getClassFile2().getMajorVersion() < 49 || ctClass.isAnnotation()) continue;
                            this.processClass(ctClass, ari, annotationToClasses, classInfo);
                        }
                        catch (NotFoundException nfe) {}
                    }
                }
                catch (Throwable t) {
                    log.log(Level.FINE, t.getMessage(), t);
                }
                finally {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            if (cl != null && cl instanceof Closeable) {
                try {
                    ((Closeable)cl).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (log.isLoggable(Level.FINE)) {
                long end = System.currentTimeMillis();
                int numberOfAnnotations = 0;
                for (Collection l : annotationToClasses.values()) {
                    numberOfAnnotations += l.size();
                }
                log.fine(Arrays.toString(urls) + "," + (end - start) + "," + numberOfAnnotations);
            }
        }
        if (trace) {
            if (ari != null) {
                log.finest("ARI=" + ari);
            } else {
                log.finest("AnnotationToClasses=" + annotationToClasses);
                log.finest("ClassInfo=" + classInfo);
            }
        }
        if (ari != null) {
            return ari;
        }
        return new AnnotationRepositoryImpl(annotationToClasses, classInfo, this.getSettings());
    }
}

