/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.papaki.util.ExtensionScanner;

public class ClassScanner {
    private static Logger log = Logger.getLogger(ClassScanner.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);

    private ClassScanner() {
    }

    public static List<String> scan(File root) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            log.fine("Scanning " + root);
            String rootPath = root.getCanonicalPath();
            List<File> classFiles = ExtensionScanner.scan(root, ".class");
            if (classFiles != null) {
                for (File classFile : classFiles) {
                    String className = classFile.getCanonicalPath();
                    if (className.startsWith(rootPath)) {
                        className = className.substring(rootPath.length() + 1);
                    }
                    if (className.endsWith(".class")) {
                        className = className.substring(0, className.lastIndexOf(".class"));
                    }
                    className = className.replace(File.separatorChar, '.');
                    if (trace) {
                        log.finest("Class=" + className);
                    }
                    result.add(className);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }
}

