/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.papaki.Annotation;
import org.jboss.papaki.AnnotationRepository;
import org.jboss.papaki.Settings;
import org.jboss.papaki.impl.ClassInfo;

public class AnnotationRepositoryImpl
implements AnnotationRepository {
    private static Logger log = Logger.getLogger(AnnotationRepositoryImpl.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);
    private static final long serialVersionUID = 2L;
    private ConcurrentMap<String, Collection<String>> annotationToClasses;
    private ConcurrentMap<String, ClassInfo> classInfo;
    private Settings settings;

    public AnnotationRepositoryImpl(Map<String, Collection<String>> annotationToClasses, Map<String, ClassInfo> classInfo, Settings settings) {
        if (annotationToClasses == null) {
            throw new IllegalArgumentException("AnnotationToClasses is null");
        }
        if (classInfo == null) {
            throw new IllegalArgumentException("ClassInfo is null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Settings is null");
        }
        this.annotationToClasses = new ConcurrentHashMap<String, Collection<String>>(annotationToClasses);
        this.classInfo = new ConcurrentHashMap<String, ClassInfo>(classInfo);
        this.settings = settings;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public Set<String> getAvailableAnnotations() {
        return Collections.unmodifiableSet(this.annotationToClasses.keySet());
    }

    @Override
    public boolean hasAnnotation(Class<?> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        return this.hasAnnotation(annotation.getName());
    }

    @Override
    public boolean hasAnnotation(String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        Collection classes = (Collection)this.annotationToClasses.get(annotation);
        if (classes != null) {
            for (String clz : classes) {
                ClassInfo ci = (ClassInfo)this.classInfo.get(clz);
                boolean result = this.checkForConcreateClassOrInterface(ci);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForConcreateClassOrInterface(ClassInfo ci) {
        if (ci != null) {
            if (!ci.isAbstract() || ci.isInterface()) {
                return true;
            }
            if (ci.getChildren() != null) {
                for (String child : ci.getChildren()) {
                    ClassInfo chd = (ClassInfo)this.classInfo.get(child);
                    boolean result = this.checkForConcreateClassOrInterface(chd);
                    if (!result) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Collection<Annotation> getAnnotation(Class<?> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        return this.getAnnotation(annotation.getName());
    }

    @Override
    public Collection<Annotation> getAnnotation(String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        Collection classes = (Collection)this.annotationToClasses.get(annotation);
        if (classes == null) {
            return null;
        }
        HashSet<Annotation> l = new HashSet<Annotation>(1);
        for (String clz : classes) {
            Collection<Annotation> childAnnotations;
            ClassInfo ci = (ClassInfo)this.classInfo.get(clz);
            Collection<Annotation> as = ci.getAnnotations(annotation);
            if (as == null || as.size() <= 0) continue;
            if (!ci.isAbstract() || ci.isInterface() || this.settings.isIncludeAbstract()) {
                l.addAll(as);
            }
            if (!this.settings.isFoldAnnotations() || (childAnnotations = this.foldAnnotations(as, ci)) == null) continue;
            l.addAll(childAnnotations);
        }
        if (l.size() == 0) {
            return null;
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public void merge(AnnotationRepository ar) {
        if (ar != null && ar instanceof AnnotationRepositoryImpl) {
            AnnotationRepositoryImpl ari = (AnnotationRepositoryImpl)ar;
            ConcurrentMap<String, Collection<String>> ac = ari.getAnnotationToClasses();
            ConcurrentMap<String, ClassInfo> ci = ari.getClassInfo();
            for (Map.Entry entry : ac.entrySet()) {
                String a = (String)entry.getKey();
                Collection v = (Collection)entry.getValue();
                if (!this.annotationToClasses.containsKey(a)) {
                    this.annotationToClasses.put(a, v);
                    continue;
                }
                Collection classes = (Collection)this.annotationToClasses.get(a);
                classes.addAll(v);
            }
            for (Map.Entry entry : ci.entrySet()) {
                String key = (String)entry.getKey();
                if (this.classInfo.containsKey(key)) continue;
                this.classInfo.put(key, (ClassInfo)entry.getValue());
            }
        }
    }

    public ConcurrentMap<String, Collection<String>> getAnnotationToClasses() {
        return this.annotationToClasses;
    }

    public ConcurrentMap<String, ClassInfo> getClassInfo() {
        return this.classInfo;
    }

    private Collection<Annotation> foldAnnotations(Collection<Annotation> annotations, ClassInfo ci) {
        if (ci != null && ci.getChildren() != null && annotations != null && annotations.size() > 0) {
            HashSet<Annotation> result = new HashSet<Annotation>(annotations.size());
            for (String childClass : ci.getChildren()) {
                Collection<Annotation> childAnnotations;
                ClassInfo chdi = (ClassInfo)this.classInfo.get(childClass);
                if (chdi == null) continue;
                if (!chdi.isAbstract() || chdi.isInterface() || this.settings.isIncludeAbstract()) {
                    for (Annotation a : annotations) {
                        Annotation na = new Annotation(a.getAnnotationClassName(), a.getAnnotation(), a.getType(), chdi.getClassName(), a.getMemberName(), a.getParameterTypes(), a.getParameterIndex());
                        result.add(na);
                    }
                }
                if (!this.settings.isFoldAnnotations() || (childAnnotations = this.foldAnnotations(annotations, chdi)) == null) continue;
                result.addAll(childAnnotations);
            }
            return result;
        }
        return null;
    }

    public int getSize() {
        int numberOfAnnotations = 0;
        for (Collection l : this.annotationToClasses.values()) {
            numberOfAnnotations += l.size();
        }
        return numberOfAnnotations;
    }

    public int getSize(Class annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation is null");
        }
        Collection l = (Collection)this.annotationToClasses.get(annotation.getName());
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    public boolean shouldBeScanned(String clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        if (this.annotationToClasses != null) {
            for (Collection c : this.annotationToClasses.values()) {
                if (!c.contains(clz)) continue;
                return true;
            }
        }
        return false;
    }

    public void registerAnnotation(String clz, String key, Annotation a) {
        ClassInfo ci = (ClassInfo)this.classInfo.get(clz);
        if (ci != null) {
            ci.addAnnotation(key, a);
        }
    }

    public void removeAllAnnotations() {
        this.annotationToClasses.clear();
        this.classInfo.clear();
    }

    public void removeAnnotations(String clz) {
        HashSet<String> remove = new HashSet<String>();
        boolean isPackage = false;
        if (clz.endsWith(".*")) {
            clz = clz.substring(0, clz.indexOf(".*"));
            isPackage = true;
        }
        for (String key : this.annotationToClasses.keySet()) {
            if (!key.equals(clz) && (!isPackage || !key.startsWith(clz))) continue;
            remove.add(key);
        }
        if (remove.size() > 0) {
            Iterator<Object> it = remove.iterator();
            while (it.hasNext()) {
                this.annotationToClasses.remove(it.next());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(AnnotationRepositoryImpl.class.getName());
        sb = sb.append("{");
        sb = sb.append("AnnotationToClasses=" + this.annotationToClasses + ",");
        sb = sb.append("ClassInfo=" + this.classInfo);
        sb = sb.append("}");
        return sb.toString();
    }
}

