/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.papaki.javalangreflect;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.jboss.papaki.Annotation;
import org.jboss.papaki.AnnotationRepository;
import org.jboss.papaki.AnnotationType;
import org.jboss.papaki.Configuration;
import org.jboss.papaki.impl.AbstractAnnotationScanner;
import org.jboss.papaki.impl.AnnotationRepositoryImpl;
import org.jboss.papaki.impl.ClassInfo;
import org.jboss.papaki.javalangreflect.SecurityActions;

public class JavaClass
extends AbstractAnnotationScanner {
    private static Logger log = Logger.getLogger(JavaClass.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);

    public JavaClass() {
        super(JavaClass.class.getName());
    }

    public JavaClass(Configuration configuration) {
        this();
        this.setConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationRepository scan(URL[] urls, ClassLoader ... cls) {
        HashMap<String, Collection<String>> annotationToClasses = new HashMap<String, Collection<String>>();
        HashMap<String, ClassInfo> classInfo = new HashMap<String, ClassInfo>();
        AnnotationRepositoryImpl ari = null;
        long start = 0L;
        if (log.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        if (urls != null) {
            URLClassLoader cl = SecurityActions.createURLClassLoader(urls, SecurityActions.getThreadContextClassLoader());
            for (URL u : urls) {
                ZipFile jar = null;
                try {
                    List<String> classes;
                    File jarFile = new File(u.toURI());
                    if (!jarFile.exists()) continue;
                    if (jarFile.isFile()) {
                        jar = new JarFile(jarFile);
                        ari = this.getScan((JarFile)jar);
                    } else {
                        ari = this.getScan(jarFile);
                    }
                    if (ari != null && ari.getSize() == 0 || (classes = this.getClassNames(new URL[]{u})) == null) continue;
                    for (String className : classes) {
                        try {
                            Class<?>[] interfaces;
                            Field[] fields;
                            Method[] methods;
                            int j;
                            int i;
                            java.lang.annotation.Annotation[][] parameterAnnotations;
                            java.lang.annotation.Annotation annotation3;
                            Class<?>[] parameters;
                            String[] parameterTypes;
                            Constructor<?>[] constructors;
                            java.lang.annotation.Annotation[] classAnnotations;
                            Class<?> clz = Class.forName(className, true, cl);
                            if (trace) {
                                log.finest("Class=" + clz.getName());
                            }
                            if (clz.isAnnotation() || !this.includeClass(clz.getModifiers())) continue;
                            if (ari == null) {
                                ClassInfo ci = (ClassInfo)classInfo.get(clz.getName());
                                if (ci == null) {
                                    ci = new ClassInfo(clz.getName());
                                }
                                if (clz.getSuperclass() != null && !clz.getSuperclass().getName().startsWith("java.")) {
                                    ClassInfo sci = (ClassInfo)classInfo.get(clz.getSuperclass().getName());
                                    if (sci == null) {
                                        sci = new ClassInfo(clz.getSuperclass().getName());
                                    }
                                    sci.addChild(clz.getName());
                                    classInfo.put(clz.getSuperclass().getName(), sci);
                                }
                                ci.setInterface(clz.isInterface());
                                ci.setAbstract(Modifier.isAbstract(clz.getModifiers()));
                                classInfo.put(clz.getName(), ci);
                            }
                            if (this.configure().isClassLevel() && (classAnnotations = clz.getAnnotations()) != null) {
                                for (java.lang.annotation.Annotation annotation2 : classAnnotations) {
                                    this.processAnnotation(annotation2, AnnotationType.CLASS, clz.getName(), null, null, -1, ari, annotationToClasses, classInfo);
                                }
                            }
                            if (!clz.isInterface() && this.configure().isConstructorLevel() && (constructors = clz.getDeclaredConstructors()) != null) {
                                for (Constructor<?> constructor : constructors) {
                                    java.lang.annotation.Annotation[] constructorAnnotations;
                                    if (trace) {
                                        log.finest("Constructor=" + constructor.getName());
                                    }
                                    if (!this.includeConstructor(constructor.getModifiers())) continue;
                                    parameterTypes = null;
                                    parameters = constructor.getParameterTypes();
                                    if (parameters != null && parameters.length > 0) {
                                        parameterTypes = new String[parameters.length];
                                        for (int i2 = 0; i2 < parameters.length; ++i2) {
                                            parameterTypes[i2] = parameters[i2].getName();
                                            if (!trace) continue;
                                            log.finest("Parameter=" + parameters[i2].getName());
                                        }
                                    }
                                    if ((constructorAnnotations = constructor.getDeclaredAnnotations()) != null) {
                                        for (java.lang.annotation.Annotation annotation3 : constructorAnnotations) {
                                            this.processAnnotation(annotation3, AnnotationType.CONSTRUCTOR, clz.getName(), null, parameterTypes, -1, ari, annotationToClasses, classInfo);
                                        }
                                    }
                                    if (parameterTypes == null || !this.configure().isParameterLevel()) continue;
                                    parameterAnnotations = constructor.getParameterAnnotations();
                                    for (i = 0; i < parameterAnnotations.length; ++i) {
                                        for (j = 0; j < parameterAnnotations[i].length; ++j) {
                                            annotation3 = parameterAnnotations[i][j];
                                            this.processAnnotation(annotation3, AnnotationType.PARAMETER, clz.getName(), null, parameterTypes, i, ari, annotationToClasses, classInfo);
                                        }
                                    }
                                }
                            }
                            if (this.configure().isMethodLevel() && (methods = clz.getDeclaredMethods()) != null) {
                                for (Method method : methods) {
                                    java.lang.annotation.Annotation[] methodAnnotations;
                                    if (trace) {
                                        log.finest("Method=" + method.getName());
                                    }
                                    if (!this.includeMethod(method.getModifiers())) continue;
                                    parameterTypes = null;
                                    parameters = method.getParameterTypes();
                                    if (parameters != null && parameters.length > 0) {
                                        parameterTypes = new String[parameters.length];
                                        for (int i3 = 0; i3 < parameters.length; ++i3) {
                                            parameterTypes[i3] = parameters[i3].getName();
                                            if (!trace) continue;
                                            log.finest("Parameter=" + parameters[i3].getName());
                                        }
                                    }
                                    if ((methodAnnotations = method.getDeclaredAnnotations()) != null) {
                                        for (java.lang.annotation.Annotation annotation3 : methodAnnotations) {
                                            this.processAnnotation(annotation3, AnnotationType.METHOD, clz.getName(), method.getName(), parameterTypes, -1, ari, annotationToClasses, classInfo);
                                        }
                                    }
                                    if (parameterTypes == null || !this.configure().isParameterLevel()) continue;
                                    parameterAnnotations = method.getParameterAnnotations();
                                    for (i = 0; i < parameterAnnotations.length; ++i) {
                                        for (j = 0; j < parameterAnnotations[i].length; ++j) {
                                            annotation3 = parameterAnnotations[i][j];
                                            this.processAnnotation(annotation3, AnnotationType.PARAMETER, clz.getName(), method.getName(), parameterTypes, i, ari, annotationToClasses, classInfo);
                                        }
                                    }
                                }
                            }
                            if (!clz.isInterface() && this.configure().isFieldLevel() && (fields = clz.getDeclaredFields()) != null) {
                                for (Field field : fields) {
                                    java.lang.annotation.Annotation[] fieldAnnotations;
                                    if (trace) {
                                        log.finest("Field=" + field.getName());
                                    }
                                    if (!this.includeField(field.getModifiers()) || (fieldAnnotations = field.getDeclaredAnnotations()) == null) continue;
                                    for (java.lang.annotation.Annotation annotation4 : fieldAnnotations) {
                                        this.processAnnotation(annotation4, AnnotationType.FIELD, clz.getName(), field.getName(), null, -1, ari, annotationToClasses, classInfo);
                                    }
                                }
                            }
                            if ((interfaces = clz.getInterfaces()) == null) continue;
                            for (Class<?> interfaceClass : interfaces) {
                                String interfaceName = interfaceClass.getName();
                                if (interfaceName.startsWith("java.")) continue;
                                ClassInfo ici = (ClassInfo)classInfo.get(interfaceName);
                                if (ici == null) {
                                    ici = new ClassInfo(interfaceName);
                                }
                                ici.addChild(clz.getName());
                                classInfo.put(interfaceName, ici);
                            }
                        }
                        catch (Throwable t) {
                            log.log(Level.FINE, t.getMessage(), t);
                        }
                    }
                }
                catch (Throwable t) {
                }
                finally {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            if (cl != null && cl instanceof Closeable) {
                try {
                    ((Closeable)cl).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (log.isLoggable(Level.FINE)) {
                long end = System.currentTimeMillis();
                int numberOfAnnotations = 0;
                for (Collection l : annotationToClasses.values()) {
                    numberOfAnnotations += l.size();
                }
                log.fine(Arrays.toString(urls) + "," + (end - start) + "," + numberOfAnnotations);
            }
        }
        if (trace) {
            if (ari != null) {
                log.finest("ARI=" + ari);
            } else {
                log.finest("AnnotationToClasses=" + annotationToClasses);
                log.finest("ClassInfo=" + classInfo);
            }
        }
        if (ari != null) {
            return ari;
        }
        return new AnnotationRepositoryImpl(annotationToClasses, classInfo, this.getSettings());
    }

    private void processAnnotation(java.lang.annotation.Annotation annotation, AnnotationType type, String className, String memberName, String[] parameterTypes, int parameterIndex, AnnotationRepositoryImpl ari, Map<String, Collection<String>> annotationToClasses, Map<String, ClassInfo> classInfo) {
        Class<? extends java.lang.annotation.Annotation> annotationClass = annotation.annotationType();
        String acn = annotationClass.getName();
        Annotation a = new Annotation(acn, annotationClass.cast(annotation), type, className, memberName, parameterTypes, parameterIndex);
        if (trace) {
            log.finest("Annotation=" + a);
        }
        if (ari != null) {
            ari.registerAnnotation(className, acn, a);
        } else {
            Collection<String> l = annotationToClasses.get(acn);
            if (l == null) {
                l = new HashSet<String>();
            }
            l.add(className);
            annotationToClasses.put(acn, l);
            ClassInfo ci = classInfo.get(className);
            ci.addAnnotation(acn, a);
        }
    }
}

