/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.Serializable;
import org.hibernate.search.backend.spi.WorkType;

public class Work<T> {
    private final T entity;
    private final Class<T> entityClass;
    private final Serializable id;
    private final WorkType type;
    private final boolean identifierWasRolledBack;

    public Work(T entity, Serializable id, WorkType type) {
        this(entity, null, id, type, false);
    }

    public Work(T entity, Serializable id, WorkType type, boolean identifierRollbackEnabled) {
        this(entity, null, id, type, identifierRollbackEnabled);
    }

    public Work(Class<T> entityType, Serializable id, WorkType type) {
        this(null, entityType, id, type, false);
    }

    public Work(T entity, WorkType type) {
        this(entity, null, null, type, false);
    }

    private Work(T entity, Class<T> entityClass, Serializable id, WorkType type, boolean identifierWasRolledBack) {
        this.entity = entity;
        this.entityClass = entityClass;
        this.id = id;
        this.type = type;
        this.identifierWasRolledBack = identifierWasRolledBack;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public T getEntity() {
        return this.entity;
    }

    public Serializable getId() {
        return this.id;
    }

    public WorkType getType() {
        return this.type;
    }

    public boolean isIdentifierWasRolledBack() {
        return this.identifierWasRolledBack;
    }
}

