/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Buffer;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class PartitionedHashMap<K, V>
implements MembershipListener {
    private Cache<K, V> l2_cache = new Cache();
    private Cache<K, V> l1_cache = null;
    private static final Log log = LogFactory.getLog(PartitionedHashMap.class);
    private JChannel ch = null;
    private Address local_addr = null;
    private View view;
    private RpcDispatcher disp = null;
    @ManagedAttribute(writable=true)
    private String props = "udp.xml";
    @ManagedAttribute(writable=true)
    private String cluster_name = "PartitionedHashMap-Cluster";
    @ManagedAttribute(writable=true)
    private long call_timeout = 1000L;
    @ManagedAttribute(writable=true)
    private long caching_time = 30000L;
    private HashFunction<K> hash_function = null;
    private Set<MembershipListener> membership_listeners = new HashSet<MembershipListener>();
    @ManagedAttribute(writable=true)
    private boolean migrate_data = false;
    private static final short PUT = 1;
    private static final short GET = 2;
    private static final short REMOVE = 3;
    protected static final Map<Short, Method> methods = Util.createConcurrentMap(8);

    public PartitionedHashMap(String props, String cluster_name) {
        this.props = props;
        this.cluster_name = cluster_name;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute
    public String getLocalAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : "null";
    }

    @ManagedAttribute
    public boolean isL1CacheEnabled() {
        return this.l1_cache != null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public long getCallTimeout() {
        return this.call_timeout;
    }

    public void setCallTimeout(long call_timeout) {
        this.call_timeout = call_timeout;
    }

    public long getCachingTime() {
        return this.caching_time;
    }

    public void setCachingTime(long caching_time) {
        this.caching_time = caching_time;
    }

    public boolean isMigrateData() {
        return this.migrate_data;
    }

    public void setMigrateData(boolean migrate_data) {
        this.migrate_data = migrate_data;
    }

    public HashFunction getHashFunction() {
        return this.hash_function;
    }

    public void setHashFunction(HashFunction<K> hash_function) {
        this.hash_function = hash_function;
    }

    public void addMembershipListener(MembershipListener l) {
        this.membership_listeners.add(l);
    }

    public void removeMembershipListener(MembershipListener l) {
        this.membership_listeners.remove(l);
    }

    public Cache<K, V> getL1Cache() {
        return this.l1_cache;
    }

    public void setL1Cache(Cache<K, V> cache) {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        this.l1_cache = cache;
    }

    public Cache<K, V> getL2Cache() {
        return this.l2_cache;
    }

    public void setL2Cache(Cache<K, V> cache) {
        if (this.l2_cache != null) {
            this.l2_cache.stop();
        }
        this.l2_cache = cache;
    }

    @ManagedOperation
    public void start() throws Exception {
        this.hash_function = new ConsistentHashFunction();
        this.addMembershipListener((MembershipListener)((Object)this.hash_function));
        this.ch = new JChannel(this.props);
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)this, this);
        CustomMarshaller marshaller = new CustomMarshaller();
        this.disp.setRequestMarshaller(marshaller);
        this.disp.setResponseMarshaller(marshaller);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
        this.ch.connect(this.cluster_name);
        this.local_addr = this.ch.getAddress();
        this.view = this.ch.getView();
    }

    @ManagedOperation
    public void stop() {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        if (this.migrate_data) {
            ArrayList<Address> members_without_me = new ArrayList<Address>(this.view.getMembers());
            members_without_me.remove(this.local_addr);
            for (Map.Entry<K, Cache.Value<V>> entry : this.l2_cache.entrySet()) {
                K key = entry.getKey();
                Address node = this.hash_function.hash(key, members_without_me);
                if (node.equals(this.local_addr)) continue;
                Cache.Value<V> val = entry.getValue();
                this.sendPut(node, key, val.getValue(), val.getTimeout(), true);
                if (!log.isTraceEnabled()) continue;
                log.trace("migrated " + key + " from " + this.local_addr + " to " + node);
            }
        }
        this.l2_cache.stop();
        this.disp.stop();
        this.ch.close();
    }

    @ManagedOperation
    public void put(K key, V val) {
        this.put(key, val, this.caching_time);
    }

    @ManagedOperation
    public void put(K key, V val, long caching_time) {
        Address dest_node = this.getNode(key);
        if (dest_node.equals(this.local_addr)) {
            this.l2_cache.put(key, val, caching_time);
        } else {
            this.sendPut(dest_node, key, val, caching_time, false);
        }
        if (this.l1_cache != null && caching_time >= 0L) {
            this.l1_cache.put(key, val, caching_time);
        }
    }

    @ManagedOperation
    public V get(K key) {
        Object val;
        if (this.l1_cache != null && (val = this.l1_cache.get(key)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("returned value " + val + " for " + key + " from L1 cache");
            }
            return (V)val;
        }
        try {
            Address dest_node = this.getNode(key);
            val = dest_node.equals(this.local_addr) ? this.l2_cache.getEntry(key) : (Cache.Value)this.disp.callRemoteMethod(dest_node, new MethodCall(2, key), new RequestOptions(ResponseMode.GET_FIRST, this.call_timeout));
            if (val != null) {
                Object retval = ((Cache.Value)val).getValue();
                if (this.l1_cache != null && ((Cache.Value)val).getTimeout() >= 0L) {
                    this.l1_cache.put(key, retval, ((Cache.Value)val).getTimeout());
                }
                return retval;
            }
            return null;
        }
        catch (Throwable t) {
            if (log.isWarnEnabled()) {
                log.warn("_get() failed", t);
            }
            return null;
        }
    }

    @ManagedOperation
    public void remove(K key) {
        block5: {
            Address dest_node = this.getNode(key);
            try {
                if (dest_node.equals(this.local_addr)) {
                    this.l2_cache.remove(key);
                } else {
                    this.disp.callRemoteMethod(dest_node, new MethodCall(3, key), new RequestOptions(ResponseMode.GET_NONE, this.call_timeout));
                }
                if (this.l1_cache != null) {
                    this.l1_cache.remove(key);
                }
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block5;
                log.warn("_remove() failed", t);
            }
        }
    }

    public V _put(K key, V val, long caching_time) {
        if (log.isTraceEnabled()) {
            log.trace("_put(" + key + ", " + val + ", " + caching_time + ")");
        }
        return this.l2_cache.put(key, val, caching_time);
    }

    public Cache.Value<V> _get(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_get(" + key + ")");
        }
        return this.l2_cache.getEntry(key);
    }

    public V _remove(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_remove(" + key + ")");
        }
        return this.l2_cache.remove(key);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("view = " + new_view);
        this.view = new_view;
        for (MembershipListener l : this.membership_listeners) {
            l.viewAccepted(new_view);
        }
        if (this.migrate_data) {
            this.migrateData();
        }
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache: " + this.l1_cache.getSize() + " entries");
        }
        sb.append("\nL2 cache: " + this.l2_cache.getSize() + "entries()");
        return sb.toString();
    }

    @ManagedOperation
    public String dump() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache:\n").append(this.l1_cache.dump());
        }
        sb.append("\nL2 cache:\n").append(this.l2_cache.dump());
        return sb.toString();
    }

    private void migrateData() {
        for (Map.Entry<K, Cache.Value<V>> entry : this.l2_cache.entrySet()) {
            K key = entry.getKey();
            Address node = this.getNode(key);
            if (node.equals(this.local_addr)) continue;
            Cache.Value<V> val = entry.getValue();
            this.put(key, val.getValue(), val.getTimeout());
            this.l2_cache.remove(key);
            if (!log.isTraceEnabled()) continue;
            log.trace("migrated " + key + " from " + this.local_addr + " to " + node);
        }
    }

    private void sendPut(Address dest, K key, V val, long caching_time, boolean synchronous) {
        block2: {
            try {
                ResponseMode mode = synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE;
                this.disp.callRemoteMethod(dest, new MethodCall(1, key, val, caching_time), new RequestOptions(mode, this.call_timeout));
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("_put() failed", t);
            }
        }
    }

    private Address getNode(K key) {
        return this.hash_function.hash(key, null);
    }

    static {
        try {
            methods.put((short)1, PartitionedHashMap.class.getMethod("_put", Object.class, Object.class, Long.TYPE));
            methods.put((short)2, PartitionedHashMap.class.getMethod("_get", Object.class));
            methods.put((short)3, PartitionedHashMap.class.getMethod("_remove", Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CustomMarshaller
    implements RpcDispatcher.Marshaller {
        static final byte NULL = 0;
        static final byte OBJ = 1;
        static final byte METHOD_CALL = 2;
        static final byte VALUE = 3;

        private CustomMarshaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Buffer objectToBuffer(Object obj) throws Exception {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(35);
            DataOutputStream out = new DataOutputStream(out_stream);
            try {
                if (obj == null) {
                    out_stream.write(0);
                    out_stream.flush();
                    Buffer buffer = new Buffer(out_stream.toByteArray());
                    return buffer;
                }
                if (obj instanceof MethodCall) {
                    out.writeByte(2);
                    MethodCall call = (MethodCall)obj;
                    out.writeShort(call.getId());
                    Object[] args = call.getArgs();
                    if (args == null || args.length == 0) {
                        out.writeShort(0);
                    } else {
                        out.writeShort(args.length);
                        for (int i = 0; i < args.length; ++i) {
                            Util.objectToStream(args[i], out);
                        }
                    }
                } else if (obj instanceof Cache.Value) {
                    Cache.Value value = (Cache.Value)obj;
                    out.writeByte(3);
                    out.writeLong(value.getTimeout());
                    Util.objectToStream(value.getValue(), out);
                } else {
                    out.writeByte(1);
                    Util.objectToStream(obj, out);
                }
                out.flush();
                Buffer buffer = new Buffer(out_stream.toByteArray());
                return buffer;
            }
            finally {
                Util.close(out);
            }
        }

        @Override
        public Object objectFromBuffer(byte[] buf, int offset, int length) throws Exception {
            if (buf == null) {
                return null;
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
            byte type = in.readByte();
            if (type == 0) {
                return null;
            }
            if (type == 2) {
                Object[] args;
                short id = in.readShort();
                short len = in.readShort();
                Object[] objectArray = args = len > 0 ? new Object[len] : null;
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = Util.objectFromStream(in);
                    }
                }
                return new MethodCall(id, args);
            }
            if (type == 3) {
                long expiration_time = in.readLong();
                Object obj = Util.objectFromStream(in);
                return new Cache.Value<Object>(obj, expiration_time);
            }
            return Util.objectFromStream(in);
        }
    }

    public static class ConsistentHashFunction<K>
    implements MembershipListener,
    HashFunction<K> {
        private SortedMap<Short, Address> nodes = new TreeMap<Short, Address>();
        private static final int HASH_SPACE = 2048;

        @Override
        public Address hash(K key, List<Address> members) {
            int index = Math.abs(key.hashCode() & 0x7FF);
            if (members != null && !members.isEmpty()) {
                TreeMap<Short, Address> tmp = new TreeMap<Short, Address>(this.nodes);
                Iterator it = tmp.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (members.contains(entry.getValue())) continue;
                    it.remove();
                }
                return ConsistentHashFunction.findFirst(tmp, index);
            }
            return ConsistentHashFunction.findFirst(this.nodes, index);
        }

        @Override
        public void viewAccepted(View new_view) {
            this.nodes.clear();
            block0: for (Address node : new_view.getMembers()) {
                int hash;
                for (int i = hash = Math.abs(node.hashCode() & 0x7FF); i < hash + 2048; ++i) {
                    short new_index = (short)(i & 0x7FF);
                    if (this.nodes.containsKey(new_index)) continue;
                    this.nodes.put(new_index, node);
                    continue block0;
                }
            }
            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("node mappings:\n");
                for (Map.Entry<Short, Address> entry : this.nodes.entrySet()) {
                    sb.append(entry.getKey() + ": " + entry.getValue()).append("\n");
                }
                log.trace(sb);
            }
        }

        @Override
        public void suspect(Address suspected_mbr) {
        }

        @Override
        public void block() {
        }

        @Override
        public void unblock() {
        }

        private static Address findFirst(Map<Short, Address> map, int index) {
            for (int i = index; i < index + 2048; ++i) {
                short new_index = (short)(i & 0x7FF);
                Address retval = map.get(new_index);
                if (retval == null) continue;
                return retval;
            }
            return null;
        }
    }

    public static interface HashFunction<K> {
        public Address hash(K var1, List<Address> var2);
    }
}

