/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.util.ThreadFactory;

public class DefaultThreadFactory
implements ThreadFactory {
    protected final String baseName;
    protected final boolean createDaemons;
    protected final boolean use_numbering;
    protected short counter = 0;
    protected boolean includeClusterName = false;
    protected String clusterName = null;
    protected boolean includeLocalAddress = false;
    protected String address = null;

    public DefaultThreadFactory(String baseName, boolean createDaemons) {
        this(baseName, createDaemons, false);
    }

    public DefaultThreadFactory(String baseName, boolean createDaemons, boolean use_numbering) {
        this.baseName = baseName;
        this.createDaemons = createDaemons;
        this.use_numbering = use_numbering;
    }

    @Override
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.includeClusterName = pattern.contains("c");
            this.includeLocalAddress = pattern.contains("l");
        }
    }

    @Override
    public void setIncludeClusterName(boolean includeClusterName) {
        this.includeClusterName = includeClusterName;
    }

    @Override
    public void setClusterName(String channelName) {
        this.clusterName = channelName;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public Thread newThread(Runnable r, String name) {
        return this.newThread(r, name, null, null);
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(r, this.baseName, null, null);
    }

    @Override
    public Thread newThread(ThreadGroup group, Runnable r, String name) {
        return this.newThread(r, name, null, null);
    }

    protected Thread newThread(Runnable r, String name, String addr, String cluster_name) {
        String thread_name = this.getNewThreadName(name, addr, cluster_name);
        Thread retval = new Thread(r, thread_name);
        retval.setDaemon(this.createDaemons);
        return retval;
    }

    @Override
    public void renameThread(String base_name, Thread thread) {
        this.renameThread(base_name, thread, this.address, this.clusterName);
    }

    public void renameThread(String base_name, Thread thread, String addr, String cluster_name) {
        String thread_name = this.getThreadName(base_name, thread, addr, cluster_name);
        if (thread_name != null) {
            thread.setName(thread_name);
        }
    }

    public void renameThread(Thread thread) {
        this.renameThread(null, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getThreadName(String base_name, Thread thread, String addr, String cluster_name) {
        if (thread == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : thread.getName());
        if (this.use_numbering) {
            short id;
            DefaultThreadFactory defaultThreadFactory = this;
            synchronized (defaultThreadFactory) {
                id = this.counter = (short)(this.counter + 1);
            }
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress && cluster_name != null) {
            sb.append(",shared=").append(cluster_name);
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        if (this.use_numbering || this.includeClusterName || this.includeLocalAddress) {
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNewThreadName(String base_name, String addr, String cluster_name) {
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : "thread");
        if (this.use_numbering) {
            short id;
            DefaultThreadFactory defaultThreadFactory = this;
            synchronized (defaultThreadFactory) {
                id = this.counter = (short)(this.counter + 1);
            }
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress && cluster_name != null) {
            sb.append(",shared=").append(cluster_name);
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        return sb.toString();
    }
}

