/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.ClearOperation;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.Operation;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapDelta
implements Delta {
    private static final Log log = LogFactory.getLog(AtomicHashMapDelta.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<Operation<Object, Object>> changeLog;
    private boolean hasClearOperation;

    @Override
    public DeltaAware merge(DeltaAware d) {
        AtomicHashMap other = d != null && d instanceof AtomicHashMap ? (AtomicHashMap)d : new AtomicHashMap();
        if (this.changeLog != null) {
            for (Operation<Object, Object> o : this.changeLog) {
                o.replay((Map<Object, Object>)other.delegate);
            }
        }
        return other;
    }

    public void addOperation(Operation<?, ?> o) {
        if (this.changeLog == null) {
            this.changeLog = new LinkedList<Operation<Object, Object>>();
        }
        if (o instanceof ClearOperation) {
            this.hasClearOperation = true;
        }
        if (trace) {
            log.tracef("Add operation %s to delta", o);
        }
        this.changeLog.add(o);
    }

    public Collection<Object> getKeys() {
        LinkedList<Object> keys = new LinkedList<Object>();
        if (this.changeLog != null) {
            for (Operation<Object, Object> o : this.changeLog) {
                Object key = o.keyAffected();
                keys.add(key);
            }
        }
        return keys;
    }

    public boolean hasClearOperation() {
        return this.hasClearOperation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AtomicHashMapDelta{changeLog=");
        sb.append(this.changeLog);
        sb.append(",hasClear=");
        sb.append(this.hasClearOperation);
        sb.append("}");
        return sb.toString();
    }

    public int getChangeLogSize() {
        return this.changeLog == null ? 0 : this.changeLog.size();
    }

    public static class Externalizer
    extends AbstractExternalizer<AtomicHashMapDelta> {
        public void writeObject(ObjectOutput output, AtomicHashMapDelta delta) throws IOException {
            if (trace) {
                log.tracef("Serializing changeLog %s", delta.changeLog);
            }
            output.writeObject(delta.changeLog);
        }

        public AtomicHashMapDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AtomicHashMapDelta delta = new AtomicHashMapDelta();
            delta.changeLog = (List)input.readObject();
            if (trace) {
                log.tracef("Deserialized changeLog %s", delta.changeLog);
            }
            return delta;
        }

        public Integer getId() {
            return 46;
        }

        public Set<Class<? extends AtomicHashMapDelta>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AtomicHashMapDelta.class});
        }
    }
}

